; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 | FileCheck %s

; Tests that bool vecreduce produces anytrue and alltrue instructions

target triple = "wasm32-unknown-unknown"

declare i1 @llvm.vector.reduce.or.v2i1(<2 x i1>)
declare i1 @llvm.vector.reduce.or.v4i1(<4 x i1>)
declare i1 @llvm.vector.reduce.or.v7i1(<7 x i1>)
declare i1 @llvm.vector.reduce.or.v8i1(<8 x i1>)
declare i1 @llvm.vector.reduce.or.v16i1(<16 x i1>)
declare i1 @llvm.vector.reduce.or.v64i1(<64 x i1>)
declare i1 @llvm.vector.reduce.and.v2i1(<2 x i1>)
declare i1 @llvm.vector.reduce.and.v4i1(<4 x i1>)
declare i1 @llvm.vector.reduce.and.v7i1(<7 x i1>)
declare i1 @llvm.vector.reduce.and.v8i1(<8 x i1>)
declare i1 @llvm.vector.reduce.and.v16i1(<16 x i1>)
declare i1 @llvm.vector.reduce.and.v64i1(<64 x i1> %x)

; =====================
; Regular vectors of i1
; =====================

define i1 @test_any_v8i1(<8 x i1> %x) {
; CHECK-LABEL: test_any_v8i1:
; CHECK:         .functype test_any_v8i1 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 15
; CHECK-NEXT:    i16x8.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 15
; CHECK-NEXT:    i16x8.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    v128.any_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %ret = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %x)
  ret i1 %ret
}

define i1 @test_all_v8i1(<8 x i1> %x) {
; CHECK-LABEL: test_all_v8i1:
; CHECK:         .functype test_all_v8i1 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 15
; CHECK-NEXT:    i16x8.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 15
; CHECK-NEXT:    i16x8.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    i16x8.all_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %ret = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %x)
  ret i1 %ret
}

define i1 @test_none_v8i1(<8 x i1> %x) {
; CHECK-LABEL: test_none_v8i1:
; CHECK:         .functype test_none_v8i1 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 15
; CHECK-NEXT:    i16x8.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push6=, 15
; CHECK-NEXT:    i16x8.shr_s $push2=, $pop1, $pop6
; CHECK-NEXT:    v128.any_true $push3=, $pop2
; CHECK-NEXT:    i32.const $push4=, 1
; CHECK-NEXT:    i32.xor $push5=, $pop3, $pop4
; CHECK-NEXT:    return $pop5
  %any = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %x)
  %none = xor i1 %any, 1
  ret i1 %none
}

define i1 @test_not_all_v8i1(<8 x i1> %x) {
; CHECK-LABEL: test_not_all_v8i1:
; CHECK:         .functype test_not_all_v8i1 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 15
; CHECK-NEXT:    i16x8.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push6=, 15
; CHECK-NEXT:    i16x8.shr_s $push2=, $pop1, $pop6
; CHECK-NEXT:    i16x8.all_true $push3=, $pop2
; CHECK-NEXT:    i32.const $push4=, 1
; CHECK-NEXT:    i32.xor $push5=, $pop3, $pop4
; CHECK-NEXT:    return $pop5
  %all = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %x)
  %notall = xor i1 %all, 1
  ret i1 %notall
}

define i1 @test_any_v16i1(<16 x i1> %x) {
; CHECK-LABEL: test_any_v16i1:
; CHECK:         .functype test_any_v16i1 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 7
; CHECK-NEXT:    i8x16.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 7
; CHECK-NEXT:    i8x16.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    v128.any_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %ret = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %x)
  ret i1 %ret
}

define i1 @test_all_v16i1(<16 x i1> %x) {
; CHECK-LABEL: test_all_v16i1:
; CHECK:         .functype test_all_v16i1 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 7
; CHECK-NEXT:    i8x16.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 7
; CHECK-NEXT:    i8x16.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    i8x16.all_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %ret = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %x)
  ret i1 %ret
}

; ==================================
; Regular vectors of larger integers
; ==================================

define i1 @test_any_v16i8(<16 x i8> %x) {
; CHECK-LABEL: test_any_v16i8:
; CHECK:         .functype test_any_v16i8 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 7
; CHECK-NEXT:    i8x16.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 7
; CHECK-NEXT:    i8x16.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    v128.any_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <16 x i8> %x to <16 x i1>
  %ret = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %bits)
  ret i1 %ret
}

define i1 @test_all_v16i8(<16 x i8> %x) {
; CHECK-LABEL: test_all_v16i8:
; CHECK:         .functype test_all_v16i8 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 7
; CHECK-NEXT:    i8x16.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 7
; CHECK-NEXT:    i8x16.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    i8x16.all_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <16 x i8> %x to <16 x i1>
  %ret = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %bits)
  ret i1 %ret
}

define i1 @test_any_v8i16(<8 x i16> %x) {
; CHECK-LABEL: test_any_v8i16:
; CHECK:         .functype test_any_v8i16 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 15
; CHECK-NEXT:    i16x8.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 15
; CHECK-NEXT:    i16x8.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    v128.any_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <8 x i16> %x to <8 x i1>
  %ret = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %bits)
  ret i1 %ret
}

define i1 @test_all_v8i16(<8 x i16> %x) {
; CHECK-LABEL: test_all_v8i16:
; CHECK:         .functype test_all_v8i16 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 15
; CHECK-NEXT:    i16x8.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 15
; CHECK-NEXT:    i16x8.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    i16x8.all_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <8 x i16> %x to <8 x i1>
  %ret = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %bits)
  ret i1 %ret
}

define i1 @test_any_v4i32(<4 x i32> %x) {
; CHECK-LABEL: test_any_v4i32:
; CHECK:         .functype test_any_v4i32 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 31
; CHECK-NEXT:    i32x4.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 31
; CHECK-NEXT:    i32x4.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    v128.any_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <4 x i32> %x to <4 x i1>
  %ret = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %bits)
  ret i1 %ret
}

define i1 @test_all_v4i32(<4 x i32> %x) {
; CHECK-LABEL: test_all_v4i32:
; CHECK:         .functype test_all_v4i32 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 31
; CHECK-NEXT:    i32x4.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 31
; CHECK-NEXT:    i32x4.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    i32x4.all_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <4 x i32> %x to <4 x i1>
  %ret = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %bits)
  ret i1 %ret
}

define i1 @test_any_v2i64(<2 x i64> %x) {
; CHECK-LABEL: test_any_v2i64:
; CHECK:         .functype test_any_v2i64 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 63
; CHECK-NEXT:    i64x2.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 63
; CHECK-NEXT:    i64x2.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    v128.any_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <2 x i64> %x to <2 x i1>
  %ret = call i1 @llvm.vector.reduce.or.v2i1(<2 x i1> %bits)
  ret i1 %ret
}

define i1 @test_all_v2i64(<2 x i64> %x) {
; CHECK-LABEL: test_all_v2i64:
; CHECK:         .functype test_all_v2i64 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 63
; CHECK-NEXT:    i64x2.shl $push1=, $0, $pop0
; CHECK-NEXT:    i32.const $push4=, 63
; CHECK-NEXT:    i64x2.shr_s $push2=, $pop1, $pop4
; CHECK-NEXT:    i64x2.all_true $push3=, $pop2
; CHECK-NEXT:    return $pop3
  %bits = trunc <2 x i64> %x to <2 x i1>
  %ret = call i1 @llvm.vector.reduce.and.v2i1(<2 x i1> %bits)
  ret i1 %ret
}

; ====================
; Unusual vector sizes
; ====================

define i1 @test_any_v7i1(<7 x i1> %x) {
; CHECK-LABEL: test_any_v7i1:
; CHECK:         .functype test_any_v7i1 (i32, i32, i32, i32, i32, i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.or $push0=, $0, $1
; CHECK-NEXT:    i32.or $push1=, $pop0, $2
; CHECK-NEXT:    i32.or $push2=, $pop1, $3
; CHECK-NEXT:    i32.or $push3=, $pop2, $4
; CHECK-NEXT:    i32.or $push4=, $pop3, $5
; CHECK-NEXT:    i32.or $push5=, $pop4, $6
; CHECK-NEXT:    return $pop5
  %ret = call i1 @llvm.vector.reduce.or.v7i1(<7 x i1> %x)
  ret i1 %ret
}

define i1 @test_all_v7i1(<7 x i1> %x) {
; CHECK-LABEL: test_all_v7i1:
; CHECK:         .functype test_all_v7i1 (i32, i32, i32, i32, i32, i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.and $push0=, $0, $1
; CHECK-NEXT:    i32.and $push1=, $pop0, $2
; CHECK-NEXT:    i32.and $push2=, $pop1, $3
; CHECK-NEXT:    i32.and $push3=, $pop2, $4
; CHECK-NEXT:    i32.and $push4=, $pop3, $5
; CHECK-NEXT:    i32.and $push5=, $pop4, $6
; CHECK-NEXT:    i32.const $push6=, 1
; CHECK-NEXT:    i32.and $push7=, $pop5, $pop6
; CHECK-NEXT:    return $pop7
  %ret = call i1 @llvm.vector.reduce.and.v7i1(<7 x i1> %x)
  ret i1 %ret
}

define i1 @test_any_v8i8(<8 x i8> %x) {
; CHECK-LABEL: test_any_v8i8:
; CHECK:         .functype test_any_v8i8 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i8x16.shuffle $push0=, $0, $0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0
; CHECK-NEXT:    i32.const $push1=, 15
; CHECK-NEXT:    i16x8.shl $push2=, $pop0, $pop1
; CHECK-NEXT:    i32.const $push5=, 15
; CHECK-NEXT:    i16x8.shr_s $push3=, $pop2, $pop5
; CHECK-NEXT:    v128.any_true $push4=, $pop3
; CHECK-NEXT:    return $pop4
  %bits = trunc <8 x i8> %x to <8 x i1>
  %ret = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %bits)
  ret i1 %ret
}

define i1 @test_all_v8i8(<8 x i8> %x) {
; CHECK-LABEL: test_all_v8i8:
; CHECK:         .functype test_all_v8i8 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i8x16.shuffle $push0=, $0, $0, 0, 0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0
; CHECK-NEXT:    i32.const $push1=, 15
; CHECK-NEXT:    i16x8.shl $push2=, $pop0, $pop1
; CHECK-NEXT:    i32.const $push5=, 15
; CHECK-NEXT:    i16x8.shr_s $push3=, $pop2, $pop5
; CHECK-NEXT:    i16x8.all_true $push4=, $pop3
; CHECK-NEXT:    return $pop4
  %bits = trunc <8 x i8> %x to <8 x i1>
  %ret = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %bits)
  ret i1 %ret
}

;; TODO: Improve this codegen.
define i1 @test_any_v64i8(<64 x i8> %x) {
; CHECK-LABEL: test_any_v64i8:
; CHECK:         .functype test_any_v64i8 (v128, v128, v128, v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push264=, __stack_pointer
; CHECK-NEXT:    i32.const $push265=, 16
; CHECK-NEXT:    i32.sub $drop=, $pop264, $pop265
; CHECK-NEXT:    i8x16.extract_lane_u $push254=, $0, 15
; CHECK-NEXT:    i8x16.extract_lane_u $push253=, $2, 15
; CHECK-NEXT:    i32.or $push255=, $pop254, $pop253
; CHECK-NEXT:    i32.const $push133=, 15
; CHECK-NEXT:    i32.shl $push256=, $pop255, $pop133
; CHECK-NEXT:    i8x16.extract_lane_u $push195=, $0, 0
; CHECK-NEXT:    i32.const $push1=, 1
; CHECK-NEXT:    i32.and $push196=, $pop195, $pop1
; CHECK-NEXT:    i8x16.extract_lane_u $push197=, $0, 1
; CHECK-NEXT:    i32.const $push368=, 1
; CHECK-NEXT:    i32.and $push198=, $pop197, $pop368
; CHECK-NEXT:    i32.const $push367=, 1
; CHECK-NEXT:    i32.shl $push199=, $pop198, $pop367
; CHECK-NEXT:    i32.or $push200=, $pop196, $pop199
; CHECK-NEXT:    i8x16.extract_lane_u $push201=, $0, 2
; CHECK-NEXT:    i32.const $push366=, 1
; CHECK-NEXT:    i32.and $push202=, $pop201, $pop366
; CHECK-NEXT:    i32.const $push9=, 2
; CHECK-NEXT:    i32.shl $push203=, $pop202, $pop9
; CHECK-NEXT:    i32.or $push204=, $pop200, $pop203
; CHECK-NEXT:    i8x16.extract_lane_u $push205=, $0, 3
; CHECK-NEXT:    i32.const $push365=, 1
; CHECK-NEXT:    i32.and $push206=, $pop205, $pop365
; CHECK-NEXT:    i32.const $push14=, 3
; CHECK-NEXT:    i32.shl $push207=, $pop206, $pop14
; CHECK-NEXT:    i32.or $push208=, $pop204, $pop207
; CHECK-NEXT:    i8x16.extract_lane_u $push209=, $0, 4
; CHECK-NEXT:    i32.const $push364=, 1
; CHECK-NEXT:    i32.and $push210=, $pop209, $pop364
; CHECK-NEXT:    i32.const $push19=, 4
; CHECK-NEXT:    i32.shl $push211=, $pop210, $pop19
; CHECK-NEXT:    i32.or $push212=, $pop208, $pop211
; CHECK-NEXT:    i8x16.extract_lane_u $push213=, $0, 5
; CHECK-NEXT:    i32.const $push363=, 1
; CHECK-NEXT:    i32.and $push214=, $pop213, $pop363
; CHECK-NEXT:    i32.const $push24=, 5
; CHECK-NEXT:    i32.shl $push215=, $pop214, $pop24
; CHECK-NEXT:    i32.or $push216=, $pop212, $pop215
; CHECK-NEXT:    i8x16.extract_lane_u $push217=, $0, 6
; CHECK-NEXT:    i32.const $push362=, 1
; CHECK-NEXT:    i32.and $push218=, $pop217, $pop362
; CHECK-NEXT:    i32.const $push29=, 6
; CHECK-NEXT:    i32.shl $push219=, $pop218, $pop29
; CHECK-NEXT:    i32.or $push220=, $pop216, $pop219
; CHECK-NEXT:    i8x16.extract_lane_u $push221=, $0, 7
; CHECK-NEXT:    i32.const $push361=, 1
; CHECK-NEXT:    i32.and $push222=, $pop221, $pop361
; CHECK-NEXT:    i32.const $push34=, 7
; CHECK-NEXT:    i32.shl $push223=, $pop222, $pop34
; CHECK-NEXT:    i32.or $push224=, $pop220, $pop223
; CHECK-NEXT:    i8x16.extract_lane_u $push225=, $0, 8
; CHECK-NEXT:    i32.const $push360=, 1
; CHECK-NEXT:    i32.and $push226=, $pop225, $pop360
; CHECK-NEXT:    i32.const $push39=, 8
; CHECK-NEXT:    i32.shl $push227=, $pop226, $pop39
; CHECK-NEXT:    i32.or $push228=, $pop224, $pop227
; CHECK-NEXT:    i8x16.extract_lane_u $push229=, $0, 9
; CHECK-NEXT:    i32.const $push359=, 1
; CHECK-NEXT:    i32.and $push230=, $pop229, $pop359
; CHECK-NEXT:    i32.const $push44=, 9
; CHECK-NEXT:    i32.shl $push231=, $pop230, $pop44
; CHECK-NEXT:    i32.or $push232=, $pop228, $pop231
; CHECK-NEXT:    i8x16.extract_lane_u $push233=, $0, 10
; CHECK-NEXT:    i32.const $push358=, 1
; CHECK-NEXT:    i32.and $push234=, $pop233, $pop358
; CHECK-NEXT:    i32.const $push49=, 10
; CHECK-NEXT:    i32.shl $push235=, $pop234, $pop49
; CHECK-NEXT:    i32.or $push236=, $pop232, $pop235
; CHECK-NEXT:    i8x16.extract_lane_u $push237=, $0, 11
; CHECK-NEXT:    i32.const $push357=, 1
; CHECK-NEXT:    i32.and $push238=, $pop237, $pop357
; CHECK-NEXT:    i32.const $push54=, 11
; CHECK-NEXT:    i32.shl $push239=, $pop238, $pop54
; CHECK-NEXT:    i32.or $push240=, $pop236, $pop239
; CHECK-NEXT:    i8x16.extract_lane_u $push241=, $0, 12
; CHECK-NEXT:    i32.const $push356=, 1
; CHECK-NEXT:    i32.and $push242=, $pop241, $pop356
; CHECK-NEXT:    i32.const $push59=, 12
; CHECK-NEXT:    i32.shl $push243=, $pop242, $pop59
; CHECK-NEXT:    i32.or $push244=, $pop240, $pop243
; CHECK-NEXT:    i8x16.extract_lane_u $push245=, $0, 13
; CHECK-NEXT:    i32.const $push355=, 1
; CHECK-NEXT:    i32.and $push246=, $pop245, $pop355
; CHECK-NEXT:    i32.const $push64=, 13
; CHECK-NEXT:    i32.shl $push247=, $pop246, $pop64
; CHECK-NEXT:    i32.or $push248=, $pop244, $pop247
; CHECK-NEXT:    i8x16.extract_lane_u $push249=, $0, 14
; CHECK-NEXT:    i32.const $push354=, 1
; CHECK-NEXT:    i32.and $push250=, $pop249, $pop354
; CHECK-NEXT:    i32.const $push69=, 14
; CHECK-NEXT:    i32.shl $push251=, $pop250, $pop69
; CHECK-NEXT:    i32.or $push252=, $pop248, $pop251
; CHECK-NEXT:    i32.or $push257=, $pop256, $pop252
; CHECK-NEXT:    i8x16.extract_lane_u $push137=, $2, 0
; CHECK-NEXT:    i32.const $push353=, 1
; CHECK-NEXT:    i32.and $push138=, $pop137, $pop353
; CHECK-NEXT:    i8x16.extract_lane_u $push139=, $2, 1
; CHECK-NEXT:    i32.const $push352=, 1
; CHECK-NEXT:    i32.and $push140=, $pop139, $pop352
; CHECK-NEXT:    i32.const $push351=, 1
; CHECK-NEXT:    i32.shl $push141=, $pop140, $pop351
; CHECK-NEXT:    i32.or $push142=, $pop138, $pop141
; CHECK-NEXT:    i8x16.extract_lane_u $push143=, $2, 2
; CHECK-NEXT:    i32.const $push350=, 1
; CHECK-NEXT:    i32.and $push144=, $pop143, $pop350
; CHECK-NEXT:    i32.const $push349=, 2
; CHECK-NEXT:    i32.shl $push145=, $pop144, $pop349
; CHECK-NEXT:    i32.or $push146=, $pop142, $pop145
; CHECK-NEXT:    i8x16.extract_lane_u $push147=, $2, 3
; CHECK-NEXT:    i32.const $push348=, 1
; CHECK-NEXT:    i32.and $push148=, $pop147, $pop348
; CHECK-NEXT:    i32.const $push347=, 3
; CHECK-NEXT:    i32.shl $push149=, $pop148, $pop347
; CHECK-NEXT:    i32.or $push150=, $pop146, $pop149
; CHECK-NEXT:    i8x16.extract_lane_u $push151=, $2, 4
; CHECK-NEXT:    i32.const $push346=, 1
; CHECK-NEXT:    i32.and $push152=, $pop151, $pop346
; CHECK-NEXT:    i32.const $push345=, 4
; CHECK-NEXT:    i32.shl $push153=, $pop152, $pop345
; CHECK-NEXT:    i32.or $push154=, $pop150, $pop153
; CHECK-NEXT:    i8x16.extract_lane_u $push155=, $2, 5
; CHECK-NEXT:    i32.const $push344=, 1
; CHECK-NEXT:    i32.and $push156=, $pop155, $pop344
; CHECK-NEXT:    i32.const $push343=, 5
; CHECK-NEXT:    i32.shl $push157=, $pop156, $pop343
; CHECK-NEXT:    i32.or $push158=, $pop154, $pop157
; CHECK-NEXT:    i8x16.extract_lane_u $push159=, $2, 6
; CHECK-NEXT:    i32.const $push342=, 1
; CHECK-NEXT:    i32.and $push160=, $pop159, $pop342
; CHECK-NEXT:    i32.const $push341=, 6
; CHECK-NEXT:    i32.shl $push161=, $pop160, $pop341
; CHECK-NEXT:    i32.or $push162=, $pop158, $pop161
; CHECK-NEXT:    i8x16.extract_lane_u $push163=, $2, 7
; CHECK-NEXT:    i32.const $push340=, 1
; CHECK-NEXT:    i32.and $push164=, $pop163, $pop340
; CHECK-NEXT:    i32.const $push339=, 7
; CHECK-NEXT:    i32.shl $push165=, $pop164, $pop339
; CHECK-NEXT:    i32.or $push166=, $pop162, $pop165
; CHECK-NEXT:    i8x16.extract_lane_u $push167=, $2, 8
; CHECK-NEXT:    i32.const $push338=, 1
; CHECK-NEXT:    i32.and $push168=, $pop167, $pop338
; CHECK-NEXT:    i32.const $push337=, 8
; CHECK-NEXT:    i32.shl $push169=, $pop168, $pop337
; CHECK-NEXT:    i32.or $push170=, $pop166, $pop169
; CHECK-NEXT:    i8x16.extract_lane_u $push171=, $2, 9
; CHECK-NEXT:    i32.const $push336=, 1
; CHECK-NEXT:    i32.and $push172=, $pop171, $pop336
; CHECK-NEXT:    i32.const $push335=, 9
; CHECK-NEXT:    i32.shl $push173=, $pop172, $pop335
; CHECK-NEXT:    i32.or $push174=, $pop170, $pop173
; CHECK-NEXT:    i8x16.extract_lane_u $push175=, $2, 10
; CHECK-NEXT:    i32.const $push334=, 1
; CHECK-NEXT:    i32.and $push176=, $pop175, $pop334
; CHECK-NEXT:    i32.const $push333=, 10
; CHECK-NEXT:    i32.shl $push177=, $pop176, $pop333
; CHECK-NEXT:    i32.or $push178=, $pop174, $pop177
; CHECK-NEXT:    i8x16.extract_lane_u $push179=, $2, 11
; CHECK-NEXT:    i32.const $push332=, 1
; CHECK-NEXT:    i32.and $push180=, $pop179, $pop332
; CHECK-NEXT:    i32.const $push331=, 11
; CHECK-NEXT:    i32.shl $push181=, $pop180, $pop331
; CHECK-NEXT:    i32.or $push182=, $pop178, $pop181
; CHECK-NEXT:    i8x16.extract_lane_u $push183=, $2, 12
; CHECK-NEXT:    i32.const $push330=, 1
; CHECK-NEXT:    i32.and $push184=, $pop183, $pop330
; CHECK-NEXT:    i32.const $push329=, 12
; CHECK-NEXT:    i32.shl $push185=, $pop184, $pop329
; CHECK-NEXT:    i32.or $push186=, $pop182, $pop185
; CHECK-NEXT:    i8x16.extract_lane_u $push187=, $2, 13
; CHECK-NEXT:    i32.const $push328=, 1
; CHECK-NEXT:    i32.and $push188=, $pop187, $pop328
; CHECK-NEXT:    i32.const $push327=, 13
; CHECK-NEXT:    i32.shl $push189=, $pop188, $pop327
; CHECK-NEXT:    i32.or $push190=, $pop186, $pop189
; CHECK-NEXT:    i8x16.extract_lane_u $push191=, $2, 14
; CHECK-NEXT:    i32.const $push326=, 1
; CHECK-NEXT:    i32.and $push192=, $pop191, $pop326
; CHECK-NEXT:    i32.const $push325=, 14
; CHECK-NEXT:    i32.shl $push193=, $pop192, $pop325
; CHECK-NEXT:    i32.or $push194=, $pop190, $pop193
; CHECK-NEXT:    i32.or $push258=, $pop257, $pop194
; CHECK-NEXT:    i8x16.extract_lane_u $push131=, $1, 15
; CHECK-NEXT:    i8x16.extract_lane_u $push130=, $3, 15
; CHECK-NEXT:    i32.or $push132=, $pop131, $pop130
; CHECK-NEXT:    i32.const $push324=, 15
; CHECK-NEXT:    i32.shl $push134=, $pop132, $pop324
; CHECK-NEXT:    i8x16.extract_lane_u $push72=, $1, 0
; CHECK-NEXT:    i32.const $push323=, 1
; CHECK-NEXT:    i32.and $push73=, $pop72, $pop323
; CHECK-NEXT:    i8x16.extract_lane_u $push74=, $1, 1
; CHECK-NEXT:    i32.const $push322=, 1
; CHECK-NEXT:    i32.and $push75=, $pop74, $pop322
; CHECK-NEXT:    i32.const $push321=, 1
; CHECK-NEXT:    i32.shl $push76=, $pop75, $pop321
; CHECK-NEXT:    i32.or $push77=, $pop73, $pop76
; CHECK-NEXT:    i8x16.extract_lane_u $push78=, $1, 2
; CHECK-NEXT:    i32.const $push320=, 1
; CHECK-NEXT:    i32.and $push79=, $pop78, $pop320
; CHECK-NEXT:    i32.const $push319=, 2
; CHECK-NEXT:    i32.shl $push80=, $pop79, $pop319
; CHECK-NEXT:    i32.or $push81=, $pop77, $pop80
; CHECK-NEXT:    i8x16.extract_lane_u $push82=, $1, 3
; CHECK-NEXT:    i32.const $push318=, 1
; CHECK-NEXT:    i32.and $push83=, $pop82, $pop318
; CHECK-NEXT:    i32.const $push317=, 3
; CHECK-NEXT:    i32.shl $push84=, $pop83, $pop317
; CHECK-NEXT:    i32.or $push85=, $pop81, $pop84
; CHECK-NEXT:    i8x16.extract_lane_u $push86=, $1, 4
; CHECK-NEXT:    i32.const $push316=, 1
; CHECK-NEXT:    i32.and $push87=, $pop86, $pop316
; CHECK-NEXT:    i32.const $push315=, 4
; CHECK-NEXT:    i32.shl $push88=, $pop87, $pop315
; CHECK-NEXT:    i32.or $push89=, $pop85, $pop88
; CHECK-NEXT:    i8x16.extract_lane_u $push90=, $1, 5
; CHECK-NEXT:    i32.const $push314=, 1
; CHECK-NEXT:    i32.and $push91=, $pop90, $pop314
; CHECK-NEXT:    i32.const $push313=, 5
; CHECK-NEXT:    i32.shl $push92=, $pop91, $pop313
; CHECK-NEXT:    i32.or $push93=, $pop89, $pop92
; CHECK-NEXT:    i8x16.extract_lane_u $push94=, $1, 6
; CHECK-NEXT:    i32.const $push312=, 1
; CHECK-NEXT:    i32.and $push95=, $pop94, $pop312
; CHECK-NEXT:    i32.const $push311=, 6
; CHECK-NEXT:    i32.shl $push96=, $pop95, $pop311
; CHECK-NEXT:    i32.or $push97=, $pop93, $pop96
; CHECK-NEXT:    i8x16.extract_lane_u $push98=, $1, 7
; CHECK-NEXT:    i32.const $push310=, 1
; CHECK-NEXT:    i32.and $push99=, $pop98, $pop310
; CHECK-NEXT:    i32.const $push309=, 7
; CHECK-NEXT:    i32.shl $push100=, $pop99, $pop309
; CHECK-NEXT:    i32.or $push101=, $pop97, $pop100
; CHECK-NEXT:    i8x16.extract_lane_u $push102=, $1, 8
; CHECK-NEXT:    i32.const $push308=, 1
; CHECK-NEXT:    i32.and $push103=, $pop102, $pop308
; CHECK-NEXT:    i32.const $push307=, 8
; CHECK-NEXT:    i32.shl $push104=, $pop103, $pop307
; CHECK-NEXT:    i32.or $push105=, $pop101, $pop104
; CHECK-NEXT:    i8x16.extract_lane_u $push106=, $1, 9
; CHECK-NEXT:    i32.const $push306=, 1
; CHECK-NEXT:    i32.and $push107=, $pop106, $pop306
; CHECK-NEXT:    i32.const $push305=, 9
; CHECK-NEXT:    i32.shl $push108=, $pop107, $pop305
; CHECK-NEXT:    i32.or $push109=, $pop105, $pop108
; CHECK-NEXT:    i8x16.extract_lane_u $push110=, $1, 10
; CHECK-NEXT:    i32.const $push304=, 1
; CHECK-NEXT:    i32.and $push111=, $pop110, $pop304
; CHECK-NEXT:    i32.const $push303=, 10
; CHECK-NEXT:    i32.shl $push112=, $pop111, $pop303
; CHECK-NEXT:    i32.or $push113=, $pop109, $pop112
; CHECK-NEXT:    i8x16.extract_lane_u $push114=, $1, 11
; CHECK-NEXT:    i32.const $push302=, 1
; CHECK-NEXT:    i32.and $push115=, $pop114, $pop302
; CHECK-NEXT:    i32.const $push301=, 11
; CHECK-NEXT:    i32.shl $push116=, $pop115, $pop301
; CHECK-NEXT:    i32.or $push117=, $pop113, $pop116
; CHECK-NEXT:    i8x16.extract_lane_u $push118=, $1, 12
; CHECK-NEXT:    i32.const $push300=, 1
; CHECK-NEXT:    i32.and $push119=, $pop118, $pop300
; CHECK-NEXT:    i32.const $push299=, 12
; CHECK-NEXT:    i32.shl $push120=, $pop119, $pop299
; CHECK-NEXT:    i32.or $push121=, $pop117, $pop120
; CHECK-NEXT:    i8x16.extract_lane_u $push122=, $1, 13
; CHECK-NEXT:    i32.const $push298=, 1
; CHECK-NEXT:    i32.and $push123=, $pop122, $pop298
; CHECK-NEXT:    i32.const $push297=, 13
; CHECK-NEXT:    i32.shl $push124=, $pop123, $pop297
; CHECK-NEXT:    i32.or $push125=, $pop121, $pop124
; CHECK-NEXT:    i8x16.extract_lane_u $push126=, $1, 14
; CHECK-NEXT:    i32.const $push296=, 1
; CHECK-NEXT:    i32.and $push127=, $pop126, $pop296
; CHECK-NEXT:    i32.const $push295=, 14
; CHECK-NEXT:    i32.shl $push128=, $pop127, $pop295
; CHECK-NEXT:    i32.or $push129=, $pop125, $pop128
; CHECK-NEXT:    i32.or $push135=, $pop134, $pop129
; CHECK-NEXT:    i8x16.extract_lane_u $push0=, $3, 0
; CHECK-NEXT:    i32.const $push294=, 1
; CHECK-NEXT:    i32.and $push2=, $pop0, $pop294
; CHECK-NEXT:    i8x16.extract_lane_u $push3=, $3, 1
; CHECK-NEXT:    i32.const $push293=, 1
; CHECK-NEXT:    i32.and $push4=, $pop3, $pop293
; CHECK-NEXT:    i32.const $push292=, 1
; CHECK-NEXT:    i32.shl $push5=, $pop4, $pop292
; CHECK-NEXT:    i32.or $push6=, $pop2, $pop5
; CHECK-NEXT:    i8x16.extract_lane_u $push7=, $3, 2
; CHECK-NEXT:    i32.const $push291=, 1
; CHECK-NEXT:    i32.and $push8=, $pop7, $pop291
; CHECK-NEXT:    i32.const $push290=, 2
; CHECK-NEXT:    i32.shl $push10=, $pop8, $pop290
; CHECK-NEXT:    i32.or $push11=, $pop6, $pop10
; CHECK-NEXT:    i8x16.extract_lane_u $push12=, $3, 3
; CHECK-NEXT:    i32.const $push289=, 1
; CHECK-NEXT:    i32.and $push13=, $pop12, $pop289
; CHECK-NEXT:    i32.const $push288=, 3
; CHECK-NEXT:    i32.shl $push15=, $pop13, $pop288
; CHECK-NEXT:    i32.or $push16=, $pop11, $pop15
; CHECK-NEXT:    i8x16.extract_lane_u $push17=, $3, 4
; CHECK-NEXT:    i32.const $push287=, 1
; CHECK-NEXT:    i32.and $push18=, $pop17, $pop287
; CHECK-NEXT:    i32.const $push286=, 4
; CHECK-NEXT:    i32.shl $push20=, $pop18, $pop286
; CHECK-NEXT:    i32.or $push21=, $pop16, $pop20
; CHECK-NEXT:    i8x16.extract_lane_u $push22=, $3, 5
; CHECK-NEXT:    i32.const $push285=, 1
; CHECK-NEXT:    i32.and $push23=, $pop22, $pop285
; CHECK-NEXT:    i32.const $push284=, 5
; CHECK-NEXT:    i32.shl $push25=, $pop23, $pop284
; CHECK-NEXT:    i32.or $push26=, $pop21, $pop25
; CHECK-NEXT:    i8x16.extract_lane_u $push27=, $3, 6
; CHECK-NEXT:    i32.const $push283=, 1
; CHECK-NEXT:    i32.and $push28=, $pop27, $pop283
; CHECK-NEXT:    i32.const $push282=, 6
; CHECK-NEXT:    i32.shl $push30=, $pop28, $pop282
; CHECK-NEXT:    i32.or $push31=, $pop26, $pop30
; CHECK-NEXT:    i8x16.extract_lane_u $push32=, $3, 7
; CHECK-NEXT:    i32.const $push281=, 1
; CHECK-NEXT:    i32.and $push33=, $pop32, $pop281
; CHECK-NEXT:    i32.const $push280=, 7
; CHECK-NEXT:    i32.shl $push35=, $pop33, $pop280
; CHECK-NEXT:    i32.or $push36=, $pop31, $pop35
; CHECK-NEXT:    i8x16.extract_lane_u $push37=, $3, 8
; CHECK-NEXT:    i32.const $push279=, 1
; CHECK-NEXT:    i32.and $push38=, $pop37, $pop279
; CHECK-NEXT:    i32.const $push278=, 8
; CHECK-NEXT:    i32.shl $push40=, $pop38, $pop278
; CHECK-NEXT:    i32.or $push41=, $pop36, $pop40
; CHECK-NEXT:    i8x16.extract_lane_u $push42=, $3, 9
; CHECK-NEXT:    i32.const $push277=, 1
; CHECK-NEXT:    i32.and $push43=, $pop42, $pop277
; CHECK-NEXT:    i32.const $push276=, 9
; CHECK-NEXT:    i32.shl $push45=, $pop43, $pop276
; CHECK-NEXT:    i32.or $push46=, $pop41, $pop45
; CHECK-NEXT:    i8x16.extract_lane_u $push47=, $3, 10
; CHECK-NEXT:    i32.const $push275=, 1
; CHECK-NEXT:    i32.and $push48=, $pop47, $pop275
; CHECK-NEXT:    i32.const $push274=, 10
; CHECK-NEXT:    i32.shl $push50=, $pop48, $pop274
; CHECK-NEXT:    i32.or $push51=, $pop46, $pop50
; CHECK-NEXT:    i8x16.extract_lane_u $push52=, $3, 11
; CHECK-NEXT:    i32.const $push273=, 1
; CHECK-NEXT:    i32.and $push53=, $pop52, $pop273
; CHECK-NEXT:    i32.const $push272=, 11
; CHECK-NEXT:    i32.shl $push55=, $pop53, $pop272
; CHECK-NEXT:    i32.or $push56=, $pop51, $pop55
; CHECK-NEXT:    i8x16.extract_lane_u $push57=, $3, 12
; CHECK-NEXT:    i32.const $push271=, 1
; CHECK-NEXT:    i32.and $push58=, $pop57, $pop271
; CHECK-NEXT:    i32.const $push270=, 12
; CHECK-NEXT:    i32.shl $push60=, $pop58, $pop270
; CHECK-NEXT:    i32.or $push61=, $pop56, $pop60
; CHECK-NEXT:    i8x16.extract_lane_u $push62=, $3, 13
; CHECK-NEXT:    i32.const $push269=, 1
; CHECK-NEXT:    i32.and $push63=, $pop62, $pop269
; CHECK-NEXT:    i32.const $push268=, 13
; CHECK-NEXT:    i32.shl $push65=, $pop63, $pop268
; CHECK-NEXT:    i32.or $push66=, $pop61, $pop65
; CHECK-NEXT:    i8x16.extract_lane_u $push67=, $3, 14
; CHECK-NEXT:    i32.const $push267=, 1
; CHECK-NEXT:    i32.and $push68=, $pop67, $pop267
; CHECK-NEXT:    i32.const $push266=, 14
; CHECK-NEXT:    i32.shl $push70=, $pop68, $pop266
; CHECK-NEXT:    i32.or $push71=, $pop66, $pop70
; CHECK-NEXT:    i32.or $push136=, $pop135, $pop71
; CHECK-NEXT:    i32.or $push259=, $pop258, $pop136
; CHECK-NEXT:    i32.const $push260=, 65535
; CHECK-NEXT:    i32.and $push261=, $pop259, $pop260
; CHECK-NEXT:    i32.const $push262=, 0
; CHECK-NEXT:    i32.ne $push263=, $pop261, $pop262
; CHECK-NEXT:    return $pop263
  %bits = trunc <64 x i8> %x to <64 x i1>
  %ret = call i1 @llvm.vector.reduce.or.v64i1(<64 x i1> %bits)
  ret i1 %ret
}

;; TODO: Improve this codegen.
define i1 @test_all_v64i8(<64 x i8> %x) {
; CHECK-LABEL: test_all_v64i8:
; CHECK:         .functype test_all_v64i8 (v128, v128, v128, v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    global.get $push287=, __stack_pointer
; CHECK-NEXT:    i32.const $push288=, 16
; CHECK-NEXT:    i32.sub $drop=, $pop287, $pop288
; CHECK-NEXT:    i8x16.extract_lane_u $push220=, $2, 0
; CHECK-NEXT:    i32.const $push1=, 1
; CHECK-NEXT:    i32.and $push221=, $pop220, $pop1
; CHECK-NEXT:    i8x16.extract_lane_u $push222=, $2, 1
; CHECK-NEXT:    i32.const $push380=, 1
; CHECK-NEXT:    i32.and $push223=, $pop222, $pop380
; CHECK-NEXT:    i32.const $push379=, 1
; CHECK-NEXT:    i32.shl $push224=, $pop223, $pop379
; CHECK-NEXT:    i32.or $push225=, $pop221, $pop224
; CHECK-NEXT:    i8x16.extract_lane_u $push226=, $2, 2
; CHECK-NEXT:    i32.const $push378=, 1
; CHECK-NEXT:    i32.and $push227=, $pop226, $pop378
; CHECK-NEXT:    i32.const $push87=, 2
; CHECK-NEXT:    i32.shl $push228=, $pop227, $pop87
; CHECK-NEXT:    i32.or $push229=, $pop225, $pop228
; CHECK-NEXT:    i8x16.extract_lane_u $push230=, $2, 3
; CHECK-NEXT:    i32.const $push377=, 1
; CHECK-NEXT:    i32.and $push231=, $pop230, $pop377
; CHECK-NEXT:    i32.const $push92=, 3
; CHECK-NEXT:    i32.shl $push232=, $pop231, $pop92
; CHECK-NEXT:    i32.or $push233=, $pop229, $pop232
; CHECK-NEXT:    i8x16.extract_lane_u $push234=, $2, 4
; CHECK-NEXT:    i32.const $push376=, 1
; CHECK-NEXT:    i32.and $push235=, $pop234, $pop376
; CHECK-NEXT:    i32.const $push97=, 4
; CHECK-NEXT:    i32.shl $push236=, $pop235, $pop97
; CHECK-NEXT:    i32.or $push237=, $pop233, $pop236
; CHECK-NEXT:    i8x16.extract_lane_u $push238=, $2, 5
; CHECK-NEXT:    i32.const $push375=, 1
; CHECK-NEXT:    i32.and $push239=, $pop238, $pop375
; CHECK-NEXT:    i32.const $push102=, 5
; CHECK-NEXT:    i32.shl $push240=, $pop239, $pop102
; CHECK-NEXT:    i32.or $push241=, $pop237, $pop240
; CHECK-NEXT:    i8x16.extract_lane_u $push242=, $2, 6
; CHECK-NEXT:    i32.const $push374=, 1
; CHECK-NEXT:    i32.and $push243=, $pop242, $pop374
; CHECK-NEXT:    i32.const $push107=, 6
; CHECK-NEXT:    i32.shl $push244=, $pop243, $pop107
; CHECK-NEXT:    i32.or $push245=, $pop241, $pop244
; CHECK-NEXT:    i8x16.extract_lane_u $push246=, $2, 7
; CHECK-NEXT:    i32.const $push373=, 1
; CHECK-NEXT:    i32.and $push247=, $pop246, $pop373
; CHECK-NEXT:    i32.const $push112=, 7
; CHECK-NEXT:    i32.shl $push248=, $pop247, $pop112
; CHECK-NEXT:    i32.or $push249=, $pop245, $pop248
; CHECK-NEXT:    i8x16.extract_lane_u $push250=, $2, 8
; CHECK-NEXT:    i32.const $push372=, 1
; CHECK-NEXT:    i32.and $push251=, $pop250, $pop372
; CHECK-NEXT:    i32.const $push117=, 8
; CHECK-NEXT:    i32.shl $push252=, $pop251, $pop117
; CHECK-NEXT:    i32.or $push253=, $pop249, $pop252
; CHECK-NEXT:    i8x16.extract_lane_u $push254=, $2, 9
; CHECK-NEXT:    i32.const $push371=, 1
; CHECK-NEXT:    i32.and $push255=, $pop254, $pop371
; CHECK-NEXT:    i32.const $push122=, 9
; CHECK-NEXT:    i32.shl $push256=, $pop255, $pop122
; CHECK-NEXT:    i32.or $push257=, $pop253, $pop256
; CHECK-NEXT:    i8x16.extract_lane_u $push258=, $2, 10
; CHECK-NEXT:    i32.const $push370=, 1
; CHECK-NEXT:    i32.and $push259=, $pop258, $pop370
; CHECK-NEXT:    i32.const $push127=, 10
; CHECK-NEXT:    i32.shl $push260=, $pop259, $pop127
; CHECK-NEXT:    i32.or $push261=, $pop257, $pop260
; CHECK-NEXT:    i8x16.extract_lane_u $push262=, $2, 11
; CHECK-NEXT:    i32.const $push369=, 1
; CHECK-NEXT:    i32.and $push263=, $pop262, $pop369
; CHECK-NEXT:    i32.const $push132=, 11
; CHECK-NEXT:    i32.shl $push264=, $pop263, $pop132
; CHECK-NEXT:    i32.or $push265=, $pop261, $pop264
; CHECK-NEXT:    i8x16.extract_lane_u $push266=, $2, 12
; CHECK-NEXT:    i32.const $push368=, 1
; CHECK-NEXT:    i32.and $push267=, $pop266, $pop368
; CHECK-NEXT:    i32.const $push137=, 12
; CHECK-NEXT:    i32.shl $push268=, $pop267, $pop137
; CHECK-NEXT:    i32.or $push269=, $pop265, $pop268
; CHECK-NEXT:    i8x16.extract_lane_u $push270=, $2, 13
; CHECK-NEXT:    i32.const $push367=, 1
; CHECK-NEXT:    i32.and $push271=, $pop270, $pop367
; CHECK-NEXT:    i32.const $push142=, 13
; CHECK-NEXT:    i32.shl $push272=, $pop271, $pop142
; CHECK-NEXT:    i32.or $push273=, $pop269, $pop272
; CHECK-NEXT:    i8x16.extract_lane_u $push274=, $2, 14
; CHECK-NEXT:    i32.const $push366=, 1
; CHECK-NEXT:    i32.and $push275=, $pop274, $pop366
; CHECK-NEXT:    i32.const $push147=, 14
; CHECK-NEXT:    i32.shl $push276=, $pop275, $pop147
; CHECK-NEXT:    i32.or $push277=, $pop273, $pop276
; CHECK-NEXT:    i8x16.extract_lane_u $push278=, $2, 15
; CHECK-NEXT:    i32.const $push151=, 15
; CHECK-NEXT:    i32.shl $push279=, $pop278, $pop151
; CHECK-NEXT:    i32.or $push280=, $pop277, $pop279
; CHECK-NEXT:    i32.const $push154=, 65535
; CHECK-NEXT:    i32.and $push281=, $pop280, $pop154
; CHECK-NEXT:    i8x16.extract_lane_u $push217=, $3, 15
; CHECK-NEXT:    i32.const $push76=, 31
; CHECK-NEXT:    i32.shl $push218=, $pop217, $pop76
; CHECK-NEXT:    i8x16.extract_lane_u $push213=, $3, 14
; CHECK-NEXT:    i32.const $push365=, 1
; CHECK-NEXT:    i32.and $push214=, $pop213, $pop365
; CHECK-NEXT:    i32.const $push72=, 30
; CHECK-NEXT:    i32.shl $push215=, $pop214, $pop72
; CHECK-NEXT:    i8x16.extract_lane_u $push209=, $3, 13
; CHECK-NEXT:    i32.const $push364=, 1
; CHECK-NEXT:    i32.and $push210=, $pop209, $pop364
; CHECK-NEXT:    i32.const $push67=, 29
; CHECK-NEXT:    i32.shl $push211=, $pop210, $pop67
; CHECK-NEXT:    i8x16.extract_lane_u $push205=, $3, 12
; CHECK-NEXT:    i32.const $push363=, 1
; CHECK-NEXT:    i32.and $push206=, $pop205, $pop363
; CHECK-NEXT:    i32.const $push62=, 28
; CHECK-NEXT:    i32.shl $push207=, $pop206, $pop62
; CHECK-NEXT:    i8x16.extract_lane_u $push201=, $3, 11
; CHECK-NEXT:    i32.const $push362=, 1
; CHECK-NEXT:    i32.and $push202=, $pop201, $pop362
; CHECK-NEXT:    i32.const $push57=, 27
; CHECK-NEXT:    i32.shl $push203=, $pop202, $pop57
; CHECK-NEXT:    i8x16.extract_lane_u $push197=, $3, 10
; CHECK-NEXT:    i32.const $push361=, 1
; CHECK-NEXT:    i32.and $push198=, $pop197, $pop361
; CHECK-NEXT:    i32.const $push52=, 26
; CHECK-NEXT:    i32.shl $push199=, $pop198, $pop52
; CHECK-NEXT:    i8x16.extract_lane_u $push193=, $3, 9
; CHECK-NEXT:    i32.const $push360=, 1
; CHECK-NEXT:    i32.and $push194=, $pop193, $pop360
; CHECK-NEXT:    i32.const $push47=, 25
; CHECK-NEXT:    i32.shl $push195=, $pop194, $pop47
; CHECK-NEXT:    i8x16.extract_lane_u $push189=, $3, 8
; CHECK-NEXT:    i32.const $push359=, 1
; CHECK-NEXT:    i32.and $push190=, $pop189, $pop359
; CHECK-NEXT:    i32.const $push42=, 24
; CHECK-NEXT:    i32.shl $push191=, $pop190, $pop42
; CHECK-NEXT:    i8x16.extract_lane_u $push185=, $3, 7
; CHECK-NEXT:    i32.const $push358=, 1
; CHECK-NEXT:    i32.and $push186=, $pop185, $pop358
; CHECK-NEXT:    i32.const $push37=, 23
; CHECK-NEXT:    i32.shl $push187=, $pop186, $pop37
; CHECK-NEXT:    i8x16.extract_lane_u $push181=, $3, 6
; CHECK-NEXT:    i32.const $push357=, 1
; CHECK-NEXT:    i32.and $push182=, $pop181, $pop357
; CHECK-NEXT:    i32.const $push32=, 22
; CHECK-NEXT:    i32.shl $push183=, $pop182, $pop32
; CHECK-NEXT:    i8x16.extract_lane_u $push177=, $3, 5
; CHECK-NEXT:    i32.const $push356=, 1
; CHECK-NEXT:    i32.and $push178=, $pop177, $pop356
; CHECK-NEXT:    i32.const $push27=, 21
; CHECK-NEXT:    i32.shl $push179=, $pop178, $pop27
; CHECK-NEXT:    i8x16.extract_lane_u $push173=, $3, 4
; CHECK-NEXT:    i32.const $push355=, 1
; CHECK-NEXT:    i32.and $push174=, $pop173, $pop355
; CHECK-NEXT:    i32.const $push22=, 20
; CHECK-NEXT:    i32.shl $push175=, $pop174, $pop22
; CHECK-NEXT:    i8x16.extract_lane_u $push169=, $3, 3
; CHECK-NEXT:    i32.const $push354=, 1
; CHECK-NEXT:    i32.and $push170=, $pop169, $pop354
; CHECK-NEXT:    i32.const $push17=, 19
; CHECK-NEXT:    i32.shl $push171=, $pop170, $pop17
; CHECK-NEXT:    i8x16.extract_lane_u $push165=, $3, 2
; CHECK-NEXT:    i32.const $push353=, 1
; CHECK-NEXT:    i32.and $push166=, $pop165, $pop353
; CHECK-NEXT:    i32.const $push12=, 18
; CHECK-NEXT:    i32.shl $push167=, $pop166, $pop12
; CHECK-NEXT:    i8x16.extract_lane_u $push161=, $3, 1
; CHECK-NEXT:    i32.const $push352=, 1
; CHECK-NEXT:    i32.and $push162=, $pop161, $pop352
; CHECK-NEXT:    i32.const $push7=, 17
; CHECK-NEXT:    i32.shl $push163=, $pop162, $pop7
; CHECK-NEXT:    i8x16.extract_lane_u $push158=, $3, 0
; CHECK-NEXT:    i32.const $push351=, 1
; CHECK-NEXT:    i32.and $push159=, $pop158, $pop351
; CHECK-NEXT:    i32.const $push3=, 16
; CHECK-NEXT:    i32.shl $push160=, $pop159, $pop3
; CHECK-NEXT:    i32.or $push164=, $pop163, $pop160
; CHECK-NEXT:    i32.or $push168=, $pop167, $pop164
; CHECK-NEXT:    i32.or $push172=, $pop171, $pop168
; CHECK-NEXT:    i32.or $push176=, $pop175, $pop172
; CHECK-NEXT:    i32.or $push180=, $pop179, $pop176
; CHECK-NEXT:    i32.or $push184=, $pop183, $pop180
; CHECK-NEXT:    i32.or $push188=, $pop187, $pop184
; CHECK-NEXT:    i32.or $push192=, $pop191, $pop188
; CHECK-NEXT:    i32.or $push196=, $pop195, $pop192
; CHECK-NEXT:    i32.or $push200=, $pop199, $pop196
; CHECK-NEXT:    i32.or $push204=, $pop203, $pop200
; CHECK-NEXT:    i32.or $push208=, $pop207, $pop204
; CHECK-NEXT:    i32.or $push212=, $pop211, $pop208
; CHECK-NEXT:    i32.or $push216=, $pop215, $pop212
; CHECK-NEXT:    i32.or $push219=, $pop218, $pop216
; CHECK-NEXT:    i32.or $push282=, $pop281, $pop219
; CHECK-NEXT:    i64.extend_i32_u $push283=, $pop282
; CHECK-NEXT:    i8x16.extract_lane_u $push79=, $0, 0
; CHECK-NEXT:    i32.const $push350=, 1
; CHECK-NEXT:    i32.and $push80=, $pop79, $pop350
; CHECK-NEXT:    i8x16.extract_lane_u $push81=, $0, 1
; CHECK-NEXT:    i32.const $push349=, 1
; CHECK-NEXT:    i32.and $push82=, $pop81, $pop349
; CHECK-NEXT:    i32.const $push348=, 1
; CHECK-NEXT:    i32.shl $push83=, $pop82, $pop348
; CHECK-NEXT:    i32.or $push84=, $pop80, $pop83
; CHECK-NEXT:    i8x16.extract_lane_u $push85=, $0, 2
; CHECK-NEXT:    i32.const $push347=, 1
; CHECK-NEXT:    i32.and $push86=, $pop85, $pop347
; CHECK-NEXT:    i32.const $push346=, 2
; CHECK-NEXT:    i32.shl $push88=, $pop86, $pop346
; CHECK-NEXT:    i32.or $push89=, $pop84, $pop88
; CHECK-NEXT:    i8x16.extract_lane_u $push90=, $0, 3
; CHECK-NEXT:    i32.const $push345=, 1
; CHECK-NEXT:    i32.and $push91=, $pop90, $pop345
; CHECK-NEXT:    i32.const $push344=, 3
; CHECK-NEXT:    i32.shl $push93=, $pop91, $pop344
; CHECK-NEXT:    i32.or $push94=, $pop89, $pop93
; CHECK-NEXT:    i8x16.extract_lane_u $push95=, $0, 4
; CHECK-NEXT:    i32.const $push343=, 1
; CHECK-NEXT:    i32.and $push96=, $pop95, $pop343
; CHECK-NEXT:    i32.const $push342=, 4
; CHECK-NEXT:    i32.shl $push98=, $pop96, $pop342
; CHECK-NEXT:    i32.or $push99=, $pop94, $pop98
; CHECK-NEXT:    i8x16.extract_lane_u $push100=, $0, 5
; CHECK-NEXT:    i32.const $push341=, 1
; CHECK-NEXT:    i32.and $push101=, $pop100, $pop341
; CHECK-NEXT:    i32.const $push340=, 5
; CHECK-NEXT:    i32.shl $push103=, $pop101, $pop340
; CHECK-NEXT:    i32.or $push104=, $pop99, $pop103
; CHECK-NEXT:    i8x16.extract_lane_u $push105=, $0, 6
; CHECK-NEXT:    i32.const $push339=, 1
; CHECK-NEXT:    i32.and $push106=, $pop105, $pop339
; CHECK-NEXT:    i32.const $push338=, 6
; CHECK-NEXT:    i32.shl $push108=, $pop106, $pop338
; CHECK-NEXT:    i32.or $push109=, $pop104, $pop108
; CHECK-NEXT:    i8x16.extract_lane_u $push110=, $0, 7
; CHECK-NEXT:    i32.const $push337=, 1
; CHECK-NEXT:    i32.and $push111=, $pop110, $pop337
; CHECK-NEXT:    i32.const $push336=, 7
; CHECK-NEXT:    i32.shl $push113=, $pop111, $pop336
; CHECK-NEXT:    i32.or $push114=, $pop109, $pop113
; CHECK-NEXT:    i8x16.extract_lane_u $push115=, $0, 8
; CHECK-NEXT:    i32.const $push335=, 1
; CHECK-NEXT:    i32.and $push116=, $pop115, $pop335
; CHECK-NEXT:    i32.const $push334=, 8
; CHECK-NEXT:    i32.shl $push118=, $pop116, $pop334
; CHECK-NEXT:    i32.or $push119=, $pop114, $pop118
; CHECK-NEXT:    i8x16.extract_lane_u $push120=, $0, 9
; CHECK-NEXT:    i32.const $push333=, 1
; CHECK-NEXT:    i32.and $push121=, $pop120, $pop333
; CHECK-NEXT:    i32.const $push332=, 9
; CHECK-NEXT:    i32.shl $push123=, $pop121, $pop332
; CHECK-NEXT:    i32.or $push124=, $pop119, $pop123
; CHECK-NEXT:    i8x16.extract_lane_u $push125=, $0, 10
; CHECK-NEXT:    i32.const $push331=, 1
; CHECK-NEXT:    i32.and $push126=, $pop125, $pop331
; CHECK-NEXT:    i32.const $push330=, 10
; CHECK-NEXT:    i32.shl $push128=, $pop126, $pop330
; CHECK-NEXT:    i32.or $push129=, $pop124, $pop128
; CHECK-NEXT:    i8x16.extract_lane_u $push130=, $0, 11
; CHECK-NEXT:    i32.const $push329=, 1
; CHECK-NEXT:    i32.and $push131=, $pop130, $pop329
; CHECK-NEXT:    i32.const $push328=, 11
; CHECK-NEXT:    i32.shl $push133=, $pop131, $pop328
; CHECK-NEXT:    i32.or $push134=, $pop129, $pop133
; CHECK-NEXT:    i8x16.extract_lane_u $push135=, $0, 12
; CHECK-NEXT:    i32.const $push327=, 1
; CHECK-NEXT:    i32.and $push136=, $pop135, $pop327
; CHECK-NEXT:    i32.const $push326=, 12
; CHECK-NEXT:    i32.shl $push138=, $pop136, $pop326
; CHECK-NEXT:    i32.or $push139=, $pop134, $pop138
; CHECK-NEXT:    i8x16.extract_lane_u $push140=, $0, 13
; CHECK-NEXT:    i32.const $push325=, 1
; CHECK-NEXT:    i32.and $push141=, $pop140, $pop325
; CHECK-NEXT:    i32.const $push324=, 13
; CHECK-NEXT:    i32.shl $push143=, $pop141, $pop324
; CHECK-NEXT:    i32.or $push144=, $pop139, $pop143
; CHECK-NEXT:    i8x16.extract_lane_u $push145=, $0, 14
; CHECK-NEXT:    i32.const $push323=, 1
; CHECK-NEXT:    i32.and $push146=, $pop145, $pop323
; CHECK-NEXT:    i32.const $push322=, 14
; CHECK-NEXT:    i32.shl $push148=, $pop146, $pop322
; CHECK-NEXT:    i32.or $push149=, $pop144, $pop148
; CHECK-NEXT:    i8x16.extract_lane_u $push150=, $0, 15
; CHECK-NEXT:    i32.const $push321=, 15
; CHECK-NEXT:    i32.shl $push152=, $pop150, $pop321
; CHECK-NEXT:    i32.or $push153=, $pop149, $pop152
; CHECK-NEXT:    i32.const $push320=, 65535
; CHECK-NEXT:    i32.and $push155=, $pop153, $pop320
; CHECK-NEXT:    i8x16.extract_lane_u $push75=, $1, 15
; CHECK-NEXT:    i32.const $push319=, 31
; CHECK-NEXT:    i32.shl $push77=, $pop75, $pop319
; CHECK-NEXT:    i8x16.extract_lane_u $push70=, $1, 14
; CHECK-NEXT:    i32.const $push318=, 1
; CHECK-NEXT:    i32.and $push71=, $pop70, $pop318
; CHECK-NEXT:    i32.const $push317=, 30
; CHECK-NEXT:    i32.shl $push73=, $pop71, $pop317
; CHECK-NEXT:    i8x16.extract_lane_u $push65=, $1, 13
; CHECK-NEXT:    i32.const $push316=, 1
; CHECK-NEXT:    i32.and $push66=, $pop65, $pop316
; CHECK-NEXT:    i32.const $push315=, 29
; CHECK-NEXT:    i32.shl $push68=, $pop66, $pop315
; CHECK-NEXT:    i8x16.extract_lane_u $push60=, $1, 12
; CHECK-NEXT:    i32.const $push314=, 1
; CHECK-NEXT:    i32.and $push61=, $pop60, $pop314
; CHECK-NEXT:    i32.const $push313=, 28
; CHECK-NEXT:    i32.shl $push63=, $pop61, $pop313
; CHECK-NEXT:    i8x16.extract_lane_u $push55=, $1, 11
; CHECK-NEXT:    i32.const $push312=, 1
; CHECK-NEXT:    i32.and $push56=, $pop55, $pop312
; CHECK-NEXT:    i32.const $push311=, 27
; CHECK-NEXT:    i32.shl $push58=, $pop56, $pop311
; CHECK-NEXT:    i8x16.extract_lane_u $push50=, $1, 10
; CHECK-NEXT:    i32.const $push310=, 1
; CHECK-NEXT:    i32.and $push51=, $pop50, $pop310
; CHECK-NEXT:    i32.const $push309=, 26
; CHECK-NEXT:    i32.shl $push53=, $pop51, $pop309
; CHECK-NEXT:    i8x16.extract_lane_u $push45=, $1, 9
; CHECK-NEXT:    i32.const $push308=, 1
; CHECK-NEXT:    i32.and $push46=, $pop45, $pop308
; CHECK-NEXT:    i32.const $push307=, 25
; CHECK-NEXT:    i32.shl $push48=, $pop46, $pop307
; CHECK-NEXT:    i8x16.extract_lane_u $push40=, $1, 8
; CHECK-NEXT:    i32.const $push306=, 1
; CHECK-NEXT:    i32.and $push41=, $pop40, $pop306
; CHECK-NEXT:    i32.const $push305=, 24
; CHECK-NEXT:    i32.shl $push43=, $pop41, $pop305
; CHECK-NEXT:    i8x16.extract_lane_u $push35=, $1, 7
; CHECK-NEXT:    i32.const $push304=, 1
; CHECK-NEXT:    i32.and $push36=, $pop35, $pop304
; CHECK-NEXT:    i32.const $push303=, 23
; CHECK-NEXT:    i32.shl $push38=, $pop36, $pop303
; CHECK-NEXT:    i8x16.extract_lane_u $push30=, $1, 6
; CHECK-NEXT:    i32.const $push302=, 1
; CHECK-NEXT:    i32.and $push31=, $pop30, $pop302
; CHECK-NEXT:    i32.const $push301=, 22
; CHECK-NEXT:    i32.shl $push33=, $pop31, $pop301
; CHECK-NEXT:    i8x16.extract_lane_u $push25=, $1, 5
; CHECK-NEXT:    i32.const $push300=, 1
; CHECK-NEXT:    i32.and $push26=, $pop25, $pop300
; CHECK-NEXT:    i32.const $push299=, 21
; CHECK-NEXT:    i32.shl $push28=, $pop26, $pop299
; CHECK-NEXT:    i8x16.extract_lane_u $push20=, $1, 4
; CHECK-NEXT:    i32.const $push298=, 1
; CHECK-NEXT:    i32.and $push21=, $pop20, $pop298
; CHECK-NEXT:    i32.const $push297=, 20
; CHECK-NEXT:    i32.shl $push23=, $pop21, $pop297
; CHECK-NEXT:    i8x16.extract_lane_u $push15=, $1, 3
; CHECK-NEXT:    i32.const $push296=, 1
; CHECK-NEXT:    i32.and $push16=, $pop15, $pop296
; CHECK-NEXT:    i32.const $push295=, 19
; CHECK-NEXT:    i32.shl $push18=, $pop16, $pop295
; CHECK-NEXT:    i8x16.extract_lane_u $push10=, $1, 2
; CHECK-NEXT:    i32.const $push294=, 1
; CHECK-NEXT:    i32.and $push11=, $pop10, $pop294
; CHECK-NEXT:    i32.const $push293=, 18
; CHECK-NEXT:    i32.shl $push13=, $pop11, $pop293
; CHECK-NEXT:    i8x16.extract_lane_u $push5=, $1, 1
; CHECK-NEXT:    i32.const $push292=, 1
; CHECK-NEXT:    i32.and $push6=, $pop5, $pop292
; CHECK-NEXT:    i32.const $push291=, 17
; CHECK-NEXT:    i32.shl $push8=, $pop6, $pop291
; CHECK-NEXT:    i8x16.extract_lane_u $push0=, $1, 0
; CHECK-NEXT:    i32.const $push290=, 1
; CHECK-NEXT:    i32.and $push2=, $pop0, $pop290
; CHECK-NEXT:    i32.const $push289=, 16
; CHECK-NEXT:    i32.shl $push4=, $pop2, $pop289
; CHECK-NEXT:    i32.or $push9=, $pop8, $pop4
; CHECK-NEXT:    i32.or $push14=, $pop13, $pop9
; CHECK-NEXT:    i32.or $push19=, $pop18, $pop14
; CHECK-NEXT:    i32.or $push24=, $pop23, $pop19
; CHECK-NEXT:    i32.or $push29=, $pop28, $pop24
; CHECK-NEXT:    i32.or $push34=, $pop33, $pop29
; CHECK-NEXT:    i32.or $push39=, $pop38, $pop34
; CHECK-NEXT:    i32.or $push44=, $pop43, $pop39
; CHECK-NEXT:    i32.or $push49=, $pop48, $pop44
; CHECK-NEXT:    i32.or $push54=, $pop53, $pop49
; CHECK-NEXT:    i32.or $push59=, $pop58, $pop54
; CHECK-NEXT:    i32.or $push64=, $pop63, $pop59
; CHECK-NEXT:    i32.or $push69=, $pop68, $pop64
; CHECK-NEXT:    i32.or $push74=, $pop73, $pop69
; CHECK-NEXT:    i32.or $push78=, $pop77, $pop74
; CHECK-NEXT:    i32.or $push156=, $pop155, $pop78
; CHECK-NEXT:    i64.extend_i32_u $push157=, $pop156
; CHECK-NEXT:    i64.and $push284=, $pop283, $pop157
; CHECK-NEXT:    i64.const $push285=, 4294967295
; CHECK-NEXT:    i64.eq $push286=, $pop284, $pop285
; CHECK-NEXT:    return $pop286
  %bits = trunc <64 x i8> %x to <64 x i1>
  %ret = call i1 @llvm.vector.reduce.and.v64i1(<64 x i1> %bits)
  ret i1 %ret
}

;; =====================
;; Test reduce after cmp
;; =====================

define i1 @test_cmp_v16i8(<16 x i8> %x) {
; CHECK-LABEL: test_cmp_v16i8:
; CHECK:         .functype test_cmp_v16i8 (v128) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i8x16.all_true $push0=, $0
; CHECK-NEXT:    i32.const $push1=, 1
; CHECK-NEXT:    i32.xor $push2=, $pop0, $pop1
; CHECK-NEXT:    return $pop2
  %zero = icmp eq <16 x i8> %x, zeroinitializer
  %ret = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %zero)
  ret i1 %ret
}
