; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefix=X64

%structA = type { %classB, float, i16, i8, i32 }
%classB = type { double, double, double }

define double @zext_shl_mul(ptr %a0, ptr %a1) {
; X86-LABEL: zext_shl_mul:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzwl (%ecx), %ecx
; X86-NEXT:    leal (%ecx,%ecx,8), %ecx
; X86-NEXT:    fldl 16(%eax,%ecx,4)
; X86-NEXT:    retl
;
; X64-LABEL: zext_shl_mul:
; X64:       # %bb.0:
; X64-NEXT:    movzwl (%rsi), %eax
; X64-NEXT:    leaq (%rax,%rax,4), %rax
; X64-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; X64-NEXT:    retq
  %ld = load i16, ptr %a1, align 2
  %zext = zext i16 %ld to i64
  %gep = getelementptr inbounds %structA, ptr %a0, i64 %zext, i32 0, i32 2
  %res = load double, ptr %gep, align 8
  ret double %res
}
