/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.odftoolkit.odfdom.type.IDREF;
import org.odftoolkit.odfdom.type.OdfDataType;

public class IDREFS
implements OdfDataType {
    private String mIdRefs;

    public IDREFS(List<IDREF> idRefList) throws IllegalArgumentException {
        if (idRefList == null || idRefList.size() == 0) {
            throw new IllegalArgumentException("parameter can not be null for IDREFS");
        }
        StringBuffer aRet = new StringBuffer();
        Iterator<IDREF> aIter = idRefList.iterator();
        while (aIter.hasNext()) {
            if (aRet.length() > 0) {
                aRet.append(' ');
            }
            String styleName = aIter.next().toString();
            aRet.append(styleName);
        }
        this.mIdRefs = aRet.toString();
    }

    public String toString() {
        return this.mIdRefs;
    }

    public static IDREFS valueOf(String stringValue) throws IllegalArgumentException {
        if (stringValue == null || stringValue.length() == 0) {
            throw new IllegalArgumentException("parameter is invalid for datatype IDREFS");
        }
        ArrayList<IDREF> aRet = new ArrayList<IDREF>();
        String[] names = stringValue.split(" ");
        for (int i = 0; i < names.length; ++i) {
            aRet.add(new IDREF(names[i]));
        }
        return new IDREFS(aRet);
    }

    public List<IDREF> getIDREFList() {
        ArrayList<IDREF> aRet = new ArrayList<IDREF>();
        String[] names = this.mIdRefs.split(" ");
        for (int i = 0; i < names.length; ++i) {
            aRet.add(new IDREF(names[i]));
        }
        return aRet;
    }

    public static boolean isValid(String stringValue) {
        if (stringValue == null) {
            return false;
        }
        if (stringValue.length() == 0) {
            return false;
        }
        String[] names = stringValue.split(" ");
        for (int i = 0; i < names.length; ++i) {
            if (IDREF.isValid(names[i])) continue;
            return false;
        }
        return true;
    }
}

