// Copyright (C) 2016 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-array.prototype.includes
description: no argument searches for a undefined value
info: |
  22.1.3.11 Array.prototype.includes ( searchElement [ , fromIndex ] )

  ...
  7. Repeat, while k < len
    a. Let elementK be the result of ? Get(O, ! ToString(k)).
    b. If SameValueZero(searchElement, elementK) is true, return true.
    c. Increase k by 1.
  ...
features: [Array.prototype.includes]
---*/

assert.sameValue([0].includes(), false, "[0].includes()");
assert.sameValue([undefined].includes(), true, "[undefined].includes()");

reportCompare(0, 0);
