// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Coptic`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x0000B7,
    0x000300,
    0x000307,
    0x002E17
  ],
  ranges: [
    [0x000304, 0x000305],
    [0x000374, 0x000375],
    [0x0003E2, 0x0003EF],
    [0x002C80, 0x002CF3],
    [0x002CF9, 0x002CFF],
    [0x0102E0, 0x0102FB]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Coptic}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Coptic}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Copt}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Copt}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Qaac}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Qaac}"
);
testPropertyEscapes(
  /^\p{scx=Coptic}+$/u,
  matchSymbols,
  "\\p{scx=Coptic}"
);
testPropertyEscapes(
  /^\p{scx=Copt}+$/u,
  matchSymbols,
  "\\p{scx=Copt}"
);
testPropertyEscapes(
  /^\p{scx=Qaac}+$/u,
  matchSymbols,
  "\\p{scx=Qaac}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x000306
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x0000B6],
    [0x0000B8, 0x0002FF],
    [0x000301, 0x000303],
    [0x000308, 0x000373],
    [0x000376, 0x0003E1],
    [0x0003F0, 0x002C7F],
    [0x002CF4, 0x002CF8],
    [0x002D00, 0x002E16],
    [0x002E18, 0x00DBFF],
    [0x00E000, 0x0102DF],
    [0x0102FC, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Coptic}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Coptic}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Copt}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Copt}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Qaac}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Qaac}"
);
testPropertyEscapes(
  /^\P{scx=Coptic}+$/u,
  nonMatchSymbols,
  "\\P{scx=Coptic}"
);
testPropertyEscapes(
  /^\P{scx=Copt}+$/u,
  nonMatchSymbols,
  "\\P{scx=Copt}"
);
testPropertyEscapes(
  /^\P{scx=Qaac}+$/u,
  nonMatchSymbols,
  "\\P{scx=Qaac}"
);

reportCompare(0, 0);
