// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Sunuwar`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [
    0x000303,
    0x00030D,
    0x000310,
    0x00032D,
    0x000331
  ],
  ranges: [
    [0x000300, 0x000301],
    [0x011BC0, 0x011BE1],
    [0x011BF0, 0x011BF9]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Sunuwar}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Sunuwar}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Sunu}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Sunu}"
);
testPropertyEscapes(
  /^\p{scx=Sunuwar}+$/u,
  matchSymbols,
  "\\p{scx=Sunuwar}"
);
testPropertyEscapes(
  /^\p{scx=Sunu}+$/u,
  matchSymbols,
  "\\p{scx=Sunu}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [
    0x000302
  ],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x0002FF],
    [0x000304, 0x00030C],
    [0x00030E, 0x00030F],
    [0x000311, 0x00032C],
    [0x00032E, 0x000330],
    [0x000332, 0x00DBFF],
    [0x00E000, 0x011BBF],
    [0x011BE2, 0x011BEF],
    [0x011BFA, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Sunuwar}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Sunuwar}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Sunu}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Sunu}"
);
testPropertyEscapes(
  /^\P{scx=Sunuwar}+$/u,
  nonMatchSymbols,
  "\\P{scx=Sunuwar}"
);
testPropertyEscapes(
  /^\P{scx=Sunu}+$/u,
  nonMatchSymbols,
  "\\P{scx=Sunu}"
);

reportCompare(0, 0);
