// Copyright (C) 2024 Mozilla Corporation. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
includes: [sm/non262.js, sm/non262-shell.js, sm/non262-Math-shell.js]
flags:
  - noStrict
description: |
  pending
esid: pending
---*/
var cosh_data = [
    [1.0000014305114746, 0.0016914556651292944],
    [1.0000019073486328, 0.001953124689559275],
    [1.000007152557373, 0.003782208044661295],
    [1.000013828277588, 0.005258943946801101],
    [1.0000171661376953, 0.005859366618129203],
    [1.0000600814819336, 0.010961831992188852],
    [1.0001168251037598, 0.015285472131830425],
    [1.0001487731933594, 0.017249319093529877],
    [1.0003981590270996, 0.028218171738655373],
    [1.000638484954834, 0.03573281468231457],
    [1.0010714530944824, 0.046287402472878776],
    [1.0030217170715332, 0.07771996527168971],
    [1.0049939155578613, 0.0998975930860278],
    [1.0092840194702148, 0.13615938768032465],
    [1.024169921875, 0.21942279004958354],
    [1.0622773170471191, 0.3511165938166055],
    [1.1223440170288086, 0.48975026711288183],
    [1.2495574951171875, 0.692556883708491],
    [1.4912219047546387, 0.954530572221414],
    [1.9838471412658691, 1.307581416910453],
    [2.1576128005981445, 1.4035188779741334],
    [2.406397819519043, 1.5250070845427517],
    [3.386958122253418, 1.8905372013072799],
    [4.451677322387695, 2.1735673399948254],
    [6.9391326904296875, 2.625091127868242],
    [7.756023406982422, 2.737434918695162],
    [8.882369995117188, 2.8740317167801948],
    [9.869171142578125, 2.97998639328949],
    [16.848876953125, 3.516549380542481],
    [16.88458251953125, 3.51867003468025],
    [18.18859100341797, 3.593185165198829],
    [18.82012176513672, 3.6273672142963385],
    [19.184181213378906, 3.646553244410946],
    [24.039520263671875, 3.872413451393967],
    [26.556991577148438, 3.972085568933329],
    [27.921104431152344, 4.022209178119238],
    [32.314666748046875, 4.168428891496629],
    [34.73008728027344, 4.240546229861005],
    [36.51556396484375, 4.290698214968891],
    [38.851287841796875, 4.352722738491574],
    [49.46875, 4.594386162629449],
    [49.67265319824219, 4.598500387004538],
    [55.821014404296875, 4.7152173401856095],
    [57.119781494140625, 4.73822104001982],
    [60.37983703613281, 4.793733825338029],
    [63.4661865234375, 4.8435923769530165],
    [63.822418212890625, 4.849190310904695],
    [64.36642456054688, 4.85767897228448],
    [65.82318115234375, 4.880061548144127],
    [68.60302734375, 4.921430721025434],
    [70.173583984375, 4.94406835208057],
    [71.80126953125, 4.967000841791218],
    [75.40786743164062, 5.016014824864732],
    [75.49771118164062, 5.017205657609766],
    [78.06475830078125, 5.0506448716550825],
    [79.64892578125, 5.0707363201405276],
    [79.8707275390625, 5.073517411135063],
    [82.14324951171875, 5.101574796209937],
    [86.42214965820312, 5.152357710985635],
    [87.75869750976562, 5.167705692500117],
    [94.24942016601562, 5.2390637098028074],
    [95.00259399414062, 5.247023676519904],
    [96.06402587890625, 5.258134994273664],
    [99.10101318359375, 5.289261389093961],
    [104.82595825195312, 5.345425863147171],
    [105.89431762695312, 5.3555664787245885],
    [106.750244140625, 5.363617180711895],
    [109.40167236328125, 5.388152468690488],
    [111.29598999023438, 5.405320225963013],
    [112.68215942382812, 5.417698597745429],
    [115.84786987304688, 5.445406415908933],
    [122.51895141601562, 5.501396249028249],
    [126.29083251953125, 5.531718947357248],
    [127.88677978515625, 5.544277233951787],
    [128.29241943359375, 5.547444176085567],
    [129.49658203125, 5.556786759298988],
    [138.73651123046875, 5.625710723366437],
    [139.18450927734375, 5.628934733085022],
    [139.9705810546875, 5.634566685055491],
    [143.6336669921875, 5.660401141376928],
    [149.2176513671875, 5.698541939965668],
    [150.61602783203125, 5.7078698961812995],
    [151.65460205078125, 5.714741890601693],
    [154.77532958984375, 5.735111323217677],
    [158.9586181640625, 5.761781191641161],
    [159.23260498046875, 5.763503378028959],
    [166.89166259765625, 5.810483079631769],
    [169.22418212890625, 5.824362807770767],
    [170.85247802734375, 5.833939098607025],
    [175.641845703125, 5.861586030831371],
    [176.47808837890625, 5.866335876872544],
    [177.0284423828125, 5.869449614294116],
    [178.81622314453125, 5.879497954012966],
    [181.28570556640625, 5.893213844044451],
    [190.84246826171875, 5.944588630523773],
    [191.39764404296875, 5.947493525920713],
    [194.2606201171875, 5.962341215900494],
    [194.89630126953125, 5.9656082276276],
    [196.72125244140625, 5.9749284849312865],
    [196.76788330078125, 5.975165500176202],
    [198.0592041015625, 5.981706804024238],
    [199.97052001953125, 5.991310884439669],
    [202.70001220703125, 6.004868209578554],
    [204.95684814453125, 6.0159406892865155],
    [206.92059326171875, 6.025476453825986],
    [211.4588623046875, 6.047172064627678],
    [211.6217041015625, 6.0479418642231595],
    [212.15936279296875, 6.050479329955437],
    [219.93341064453125, 6.086466833749719],
    [223.34747314453125, 6.101870903204913],
    [228.56036376953125, 6.1249427443985525],
    [229.53656005859375, 6.129204755426344],
    [231.15753173828125, 6.136241935513706],
    [235.22589111328125, 6.153688953514383],
    [237.17108154296875, 6.1619244798633215],
    [237.904541015625, 6.165012268502458],
    [243.202392578125, 6.187036941752032],
    [244.296875, 6.191527178125454],
    [245.39239501953125, 6.196001570568187],
    [245.80389404296875, 6.197677082130341],
    [249.68365478515625, 6.2133379061260285],
    [252.32763671875, 6.223871642756905],
    [253.4725341796875, 6.228398760115369],
    [264.1583251953125, 6.269692237869835],
    [265.867919921875, 6.276143287577458],
    [273.893798828125, 6.305884283737176],
    [274.060546875, 6.306492908028797],
    [274.06298828125, 6.3065018163217115],
    [275.31201171875, 6.31104892482331],
    [281.2171630859375, 6.3322712125431915],
    [284.3428955078125, 6.343324976847916],
    [284.8428955078125, 6.345081883725142],
    [287.3035888671875, 6.353683609448096],
    [290.8973388671875, 6.366114643735997],
    [293.0467529296875, 6.373476431987165],
    [293.048583984375, 6.3734826803404045],
    [296.819091796875, 6.3862671775996915],
    [297.6572265625, 6.389086936901673],
    [308.40625, 6.424562459508495],
    [316.5472412109375, 6.4506171773701535],
    [320.2418212890625, 6.462221144761522],
    [322.33642578125, 6.468740575092418],
    [323.5101318359375, 6.472375224718483],
    [327.8939208984375, 6.485834999462654],
    [328.0833740234375, 6.486412623146554],
    [328.214599609375, 6.486812521370483],
    [332.13916015625, 6.498698952535687],
    [339.6888427734375, 6.521175044233963],
    [340.171630859375, 6.522595306993373],
    [340.22998046875, 6.522766822935215],
    [340.9984130859375, 6.52502285413445],
    [347.719482421875, 6.5445411825986985],
    [347.921142578125, 6.5451209675856825],
    [349.8392333984375, 6.55061885367159],
    [353.1812744140625, 6.560126626713879],
    [353.3170166015625, 6.560510895819139],
    [354.9730224609375, 6.565186990039135],
    [355.6412353515625, 6.567067660815945],
    [363.193603515625, 6.588081320423386],
    [363.7503662109375, 6.5896131163651415],
    [366.66650390625, 6.597598047275183],
    [370.5828857421875, 6.608222493065004],
    [371.822998046875, 6.611563301604297],
    [375.8822021484375, 6.622421213257873],
    [377.1107177734375, 6.625684248051368],
    [377.588623046875, 6.626950731244344],
    [378.8428955078125, 6.630267034079059],
    [379.1123046875, 6.630977920761718],
    [381.1038818359375, 6.636217452968849],
    [382.1112060546875, 6.638857149899159],
    [382.9927978515625, 6.641161660644278],
    [387.1845703125, 6.652047018118426],
    [389.669921875, 6.658445560711748],
    [389.804443359375, 6.658790721334144],
    [396.3114013671875, 6.675345858154136],
    [397.005126953125, 6.677094789236718],
    [397.1934814453125, 6.6775691166680895],
    [397.8046875, 6.679106750673113],
    [398.8426513671875, 6.681712590609845],
    [399.1663818359375, 6.682523938576487],
    [399.2547607421875, 6.68274532345516],
    [400.33984375, 6.685459416477178],
    [403.9578857421875, 6.694456277839498],
    [404.279541015625, 6.6952522228540765],
    [405.0574951171875, 6.6971746771142415],
    [407.328125, 6.702764738337774],
    [407.547119140625, 6.7033022311799595],
    [410.5994873046875, 6.710763953621196],
    [410.8016357421875, 6.711256159037373],
    [411.129638671875, 6.712054288828399],
    [411.9053955078125, 6.713939407502346],
    [415.5833740234375, 6.722828986708716],
    [417.669189453125, 6.727835453862132],
    [420.517822265625, 6.734632628835641],
    [424.3853759765625, 6.743787740494532],
    [424.7154541015625, 6.744565219553757],
    [436.3419189453125, 6.7715720212680655],
    [438.501953125, 6.776510146304201],
    [439.3369140625, 6.778412462065226],
    [445.5606689453125, 6.79247934060035],
    [452.9901123046875, 6.809016260337229],
    [453.77490234375, 6.810747231716348],
    [456.7745361328125, 6.817335895109251],
    [457.9520263671875, 6.819910421197311],
    [458.6795654296875, 6.821497844004013],
    [460.5164794921875, 6.8254946428721475],
    [461.8717041015625, 6.828433164406687],
    [464.7025146484375, 6.834543470287694],
    [467.0626220703125, 6.839609377592375],
    [467.0712890625, 6.839627933844213],
    [470.096923828125, 6.846084943645239],
    [475.1607666015625, 6.856799276049143],
    [477.5537109375, 6.861822721577315],
    [478.626220703125, 6.864066049482581],
    [478.7958984375, 6.864420497333681],
    [479.6864013671875, 6.866278653973069],
    [479.7867431640625, 6.866487814627139],
    [479.9122314453125, 6.8667493311188395],
    [482.4793701171875, 6.872084270243208],
    [482.5181884765625, 6.872164723177875],
    [483.8797607421875, 6.874982560453874],
    [484.4649658203125, 6.876191234145179],
    [485.3258056640625, 6.877966548833207],
    [490.57373046875, 6.888721726428236],
    [493.7423095703125, 6.89515989558997],
    [494.272216796875, 6.896232568812718],
    [496.44775390625, 6.900624415355815],
    [497.0401611328125, 6.901816998553275],
    [498.234130859375, 6.9042162822876465],
    [665.0791015625, 7.193052598670793],
    [1170.29150390625, 7.758155143419732],
    [2058.7958984375, 8.323023697145112],
    [5824.533203125, 9.36298131161099],
    [9114.30859375, 9.810748008110926],
    [31388.40625, 11.047341056314202],
    [53732.765625, 11.584925435512535],
    [117455.09375, 12.366958539207397],
    [246210.625, 13.107089828327874],
    [513670.125, 13.84248373881162],
    [788353.25, 14.27084873575108],
    [1736171, 15.060339852215408],
    [3770530, 15.835873313657556],
    [4344090, 15.977474039173265],
    [11419360, 16.943967899150145],
    [31023240, 17.943394339560967],
    [40665424, 18.214035936745432],
    [129788064, 19.374560581709215],
    [225668224, 19.927723623778547],
    [450631936, 20.619308638400597],
    [750941952, 21.129986093026698],
    [1887358976, 22.05159150215413],
    [3738011648, 22.734966842639743],
    [7486695424, 23.42954051928097],
    [12668080128, 23.955498471391667],
    [23918272512, 24.591055724582848],
    [48862560256, 25.305424481799395],
    [113763549184, 26.150535181949436],
    [161334755328, 26.499894449532565],
    [321933279232, 27.19075733422632],
    [715734122496, 27.989721778208146],
    [1875817529344, 28.953212876533797]
];

var sloppy_tolerance = 9;  // FIXME

for (var [x, y] of cosh_data)
    assertNear(Math.acosh(x), y, sloppy_tolerance);

assertNear(Math.acosh(1e300), 691.4686750787737, sloppy_tolerance);
assertNear(Math.acosh(1.0000000001), 0.000014142136208675862, sloppy_tolerance);

for (var i = 0; i <= 100; i++) {
    var x = (i - 50) / 5;
    var y = Math.cosh(x);
    var z = Math.acosh(y);
    assertNear(z, Math.abs(x), sloppy_tolerance);
}

for (var i = 1; i < 20; i++)
    assertNear(Math.acosh(Math.cosh(i)), i, sloppy_tolerance);


reportCompare(0, 0);
