/*
 * Copyright (C) 2020 Pascal Knecht
 * Copyright (C) 2014 Martin Willi
 *
 * Copyright (C) secunet Security Networks AG
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include <test_suite.h>

#include <unistd.h>

#include "tls_crypto.h"

START_TEST(test_cipher_names)
{
	char buf[128];

#define CHECK_NAME(x) { \
	snprintf(buf, sizeof(buf), "%N", tls_cipher_suite_names, x); \
	ck_assert_str_eq(#x, buf); }

	CHECK_NAME(TLS_NULL_WITH_NULL_NULL);
	CHECK_NAME(TLS_RSA_WITH_NULL_MD5);
	CHECK_NAME(TLS_RSA_WITH_NULL_SHA);
	CHECK_NAME(TLS_RSA_EXPORT_WITH_RC4_40_MD5);
	CHECK_NAME(TLS_RSA_WITH_RC4_128_MD5);
	CHECK_NAME(TLS_RSA_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5);
	CHECK_NAME(TLS_RSA_WITH_IDEA_CBC_SHA);
	CHECK_NAME(TLS_RSA_EXPORT_WITH_DES40_CBC_SHA);
	CHECK_NAME(TLS_RSA_WITH_DES_CBC_SHA);
	CHECK_NAME(TLS_RSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_WITH_DES_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_WITH_DES_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_WITH_DES_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_DES_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_EXPORT_WITH_RC4_40_MD5);
	CHECK_NAME(TLS_DH_anon_WITH_RC4_128_MD5);
	CHECK_NAME(TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_WITH_DES_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_KRB5_WITH_DES_CBC_SHA);
	CHECK_NAME(TLS_KRB5_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_KRB5_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_KRB5_WITH_IDEA_CBC_SHA);
	CHECK_NAME(TLS_KRB5_WITH_DES_CBC_MD5);
	CHECK_NAME(TLS_KRB5_WITH_3DES_EDE_CBC_MD5);
	CHECK_NAME(TLS_KRB5_WITH_RC4_128_MD5);
	CHECK_NAME(TLS_KRB5_WITH_IDEA_CBC_MD5);
	CHECK_NAME(TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA);
	CHECK_NAME(TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA);
	CHECK_NAME(TLS_KRB5_EXPORT_WITH_RC4_40_SHA);
	CHECK_NAME(TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5);
	CHECK_NAME(TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5);
	CHECK_NAME(TLS_KRB5_EXPORT_WITH_RC4_40_MD5);
	CHECK_NAME(TLS_PSK_WITH_NULL_SHA);
	CHECK_NAME(TLS_DHE_PSK_WITH_NULL_SHA);
	CHECK_NAME(TLS_RSA_PSK_WITH_NULL_SHA);
	CHECK_NAME(TLS_RSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_RSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_RSA_WITH_NULL_SHA256);
	CHECK_NAME(TLS_RSA_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_RSA_WITH_AES_256_CBC_SHA256);
	CHECK_NAME(TLS_DH_DSS_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_DH_RSA_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_DHE_DSS_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_DH_DSS_WITH_AES_256_CBC_SHA256);
	CHECK_NAME(TLS_DH_RSA_WITH_AES_256_CBC_SHA256);
	CHECK_NAME(TLS_DHE_DSS_WITH_AES_256_CBC_SHA256);
	CHECK_NAME(TLS_DHE_RSA_WITH_AES_256_CBC_SHA256);
	CHECK_NAME(TLS_DH_anon_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_DH_anon_WITH_AES_256_CBC_SHA256);
	CHECK_NAME(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA);
	CHECK_NAME(TLS_PSK_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_PSK_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_PSK_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_PSK_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_DHE_PSK_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_DHE_PSK_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_DHE_PSK_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_RSA_PSK_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_RSA_PSK_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_RSA_PSK_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_RSA_WITH_SEED_CBC_SHA);
	CHECK_NAME(TLS_DH_DSS_WITH_SEED_CBC_SHA);
	CHECK_NAME(TLS_DH_RSA_WITH_SEED_CBC_SHA);
	CHECK_NAME(TLS_DHE_DSS_WITH_SEED_CBC_SHA);
	CHECK_NAME(TLS_DHE_RSA_WITH_SEED_CBC_SHA);
	CHECK_NAME(TLS_DH_anon_WITH_SEED_CBC_SHA);
	CHECK_NAME(TLS_RSA_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_RSA_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_DHE_RSA_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_DHE_RSA_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_DH_RSA_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_DH_RSA_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_DHE_DSS_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_DHE_DSS_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_DH_DSS_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_DH_DSS_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_DH_anon_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_DH_anon_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_PSK_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_PSK_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_DHE_PSK_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_DHE_PSK_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_RSA_PSK_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_RSA_PSK_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_PSK_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_PSK_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_PSK_WITH_NULL_SHA256);
	CHECK_NAME(TLS_PSK_WITH_NULL_SHA384);
	CHECK_NAME(TLS_DHE_PSK_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_DHE_PSK_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_DHE_PSK_WITH_NULL_SHA256);
	CHECK_NAME(TLS_DHE_PSK_WITH_NULL_SHA384);
	CHECK_NAME(TLS_RSA_PSK_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_RSA_PSK_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_RSA_PSK_WITH_NULL_SHA256);
	CHECK_NAME(TLS_RSA_PSK_WITH_NULL_SHA384);
	CHECK_NAME(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256);
	CHECK_NAME(TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256);
	CHECK_NAME(TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
	CHECK_NAME(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256);
	CHECK_NAME(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
	CHECK_NAME(TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256);
	CHECK_NAME(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256);
	CHECK_NAME(TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256);
	CHECK_NAME(TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256);
	CHECK_NAME(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256);
	CHECK_NAME(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256);
	CHECK_NAME(TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256);
	CHECK_NAME(TLS_EMPTY_RENEGOTIATION_INFO_SCSV);
	CHECK_NAME(TLS_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_CHACHA20_POLY1305_SHA256);
	CHECK_NAME(TLS_AES_128_CCM_SHA256);
	CHECK_NAME(TLS_AES_128_CCM_8_SHA256);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_NULL_SHA);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_NULL_SHA);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_ECDH_RSA_WITH_NULL_SHA);
	CHECK_NAME(TLS_ECDH_RSA_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_ECDH_RSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_ECDH_RSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_NULL_SHA);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_ECDH_anon_WITH_NULL_SHA);
	CHECK_NAME(TLS_ECDH_anon_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_ECDH_anon_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_ECDH_anon_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256);
	CHECK_NAME(TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_RC4_128_SHA);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_NULL_SHA);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_NULL_SHA256);
	CHECK_NAME(TLS_ECDHE_PSK_WITH_NULL_SHA384);
	CHECK_NAME(TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
	CHECK_NAME(TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256);
	CHECK_NAME(TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
}
END_TEST

Suite *suites_suite_create()
{
	Suite *s;
	TCase *tc;

	s = suite_create("suites");

	tc = tcase_create("cipher-names");
	tcase_add_test(tc, test_cipher_names);
	suite_add_tcase(s, tc);

	return s;
}
