#!/bin/sh
# For each file in new/, check if that path exists in game content.
# If not in content, print the path (relative to new/).
# Usage: check-in-content.sh [new_dir] [content.uqm]

NEW_DIR="${1:-unpack/tmp-repack/new}"
CONTENT_ZIP="${2:-/usr/share/games/uqm/content/packages/uqm-0.8.0-content.uqm}"

test -d "$NEW_DIR" || { echo "check-in-content.sh: no dir: $NEW_DIR" >&2; exit 1; }
test -r "$CONTENT_ZIP" || { echo "check-in-content.sh: no content: $CONTENT_ZIP" >&2; exit 1; }

# Strip trailing slash from NEW_DIR for correct prefix removal
NEW_DIR="${NEW_DIR%/}"

find "$NEW_DIR" -type f | sort | while read -r f; do
  rel="${f#$NEW_DIR/}"
  unzip -l -q "$CONTENT_ZIP" "$rel" >/dev/null 2>&1 || echo "$rel"
done
