# Данные текущего пользователя

В предыдущей главе система безопасности (основанная на системе внедрения зависимостей) передавала *функции, обрабатывающей эндпоинт,* `токен` в виде `строки`:

{* ../../docs_src/security/tutorial001_an_py39.py hl[12] *}

Это пока что не слишком нам полезно. Давайте изменим код так, чтобы он возвращал нам данные пользователя, отправившего запрос.

## Создание модели пользователя

Сначала создадим Pydantic-модель пользователя.

Точно так же, как мы использовали Pydantic для объявления тел запросов, мы можем использовать его где угодно:

{* ../../docs_src/security/tutorial002_an_py310.py hl[5,12:6] *}

## Создание зависимости `get_current_user`

Давайте создадим зависимость `get_current_user`.

Помните, что у зависимостей могут быть подзависимости?

`get_current_user` как раз будет иметь подзависимость `oauth2_scheme`, которую мы создали ранее.

Аналогично тому, как мы делали это ранее в *обработчике эндпоинта*  наша новая зависимость `get_current_user` будет получать `token` в виде `строки` от подзависимости `oauth2_scheme`:

{* ../../docs_src/security/tutorial002_an_py310.py hl[25] *}

## Получение данных пользователя

`get_current_user` будет использовать созданную нами (ненастоящую) служебную функцию, которая принимает токен в виде `строки` и возвращает нашу Pydantic-модель `User`:

{* ../../docs_src/security/tutorial002_an_py310.py hl[19:22,26:27] *}

## Внедрение зависимости текущего пользователя

Теперь мы можем использовать тот же `Depends` с нашей зависимостью `get_current_user` в *функции обрабатывающей эндпоинт*:

{* ../../docs_src/security/tutorial002_an_py310.py hl[31] *}

Обратите внимание, что мы объявляем тип переменной `current_user` как Pydantic-модель `User`.

Это поможет выполнить внутри функции все проверки автозаполнения и типа.

/// tip | Подсказка
Возможно, вы помните, что тело запроса также объявляется с помощью Pydantic-моделей.

В этом месте у **FastAPI** не возникнет проблем, потому что вы используете `Depends`.
///

/// check | Заметка
То, как устроена эта система зависимостей, позволяет нам иметь различные зависимости, которые возвращают модель `User`.

Мы не ограничены наличием только одной зависимости, которая может возвращать данные такого типа.
///

## Другие модели

Теперь вы можете получать информацию о текущем пользователе непосредственно в *функции обрабатывающей эндпоинт* и работать с механизмами безопасности на уровне **Внедрения Зависимостей**, используя `Depends`.

Причем для обеспечения требований безопасности можно использовать любую модель или данные (в данном случае - Pydantic-модель `User`).

Но вы не ограничены использованием какой-то конкретной моделью данных, классом или типом.

Вы хотите использовать в модели `id` и `email`, а `username` вам не нужен? Ну разумеется. Воспользуйтесь тем же инструментарием.

Вам нужны только `строки`? Или только `словари`? Или непосредственно экземпляр модели класса базы данных? Все это работает точно также.

У вас нет пользователей, которые входят в ваше приложение, а только роботы, боты или другие системы, у которых есть только токен доступа? Опять же, все работает одинаково.

Просто используйте любую модель, любой класс, любую базу данных, которые нужны для вашего приложения. Система внедрения зависимостей **FastAPI** поможет вам в этом.

## Размер кода

Этот пример может показаться многословным. Следует иметь в виду, что в одном файле мы смешиваем безопасность, модели данных, служебные функции и *эндпоинты*.

Но вот ключевой момент:

Все, что касается безопасности и внедрения зависимостей, пишется один раз.

И вы можете сделать его настолько сложным, насколько захотите. И все это будет написано только один раз, в одном месте, со всей своей гибкостью.

И у вас могут быть тысячи конечных точек (*эндпоинтов*), использующих одну и ту же систему безопасности.

И все они (или любая их часть по вашему желанию) могут воспользоваться преимуществами повторного использования этих зависимостей или любых других зависимостей, которые вы создадите.

И все эти тысячи *эндпоинтов* могут составлять всего 3 строки:

{* ../../docs_src/security/tutorial002_an_py310.py hl[30:32] *}

## Резюме

Теперь вы можете получать данные о текущем пользователе непосредственно в своей *функции обработчике эндпоинта*.

Мы уже на полпути к этому.

Осталось лишь добавить *эндпоинт* для отправки пользователем/клиентом своих `имени пользователя` и `пароля`.

Это будет рассмотрено в следующем разделе.
