install("gpow","GGp");
install("gp2c_gp2crand","G","gp2crand","./affect.gp.so");
install("gp2c_randprime","G","randprime","./affect.gp.so");

powmod(a,b,c)=lift(gpow(Mod(a,c),b))

buildkey(N)=
{
  local(p,q,e,phi);
  p=randprime(N);
  q=randprime(N);
  phi=(p-1)*(q-1);
  until(gcd(e,phi)==1,e=gp2crand(p*q));
  [[e,p*q],[powmod(e,-1,phi),p*q]]
}

crypt(data,publickey)=
{
  powmod(data,publickey[1],publickey[2])
}

decrypt(data,privatekey)=
{
  powmod(data,privatekey[1],privatekey[2])
}
