/**
 * \file pappsomspp/processing/cbor/psm/psmcbor2json.h
 * \date 19/07/2025
 * \author Olivier Langella
 * \brief convert CBOR PSM to JSON
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once


#include "psmfilereaderbase.h"
#include "pappsomspp/core/processing/cbor/jsonstreamwriter.h"

namespace pappso::cbor::psm
{
/**
 * @todo write docs
 */
class PsmCbor2Json : public PsmFileReaderBase
{
  public:
  /**
   * Default constructor
   */
  PsmCbor2Json(pappso::cbor::JsonStreamWriter *json_output_p);

  /**
   * Destructor
   */
  virtual ~PsmCbor2Json();


  void close() override;

  protected:
  void informationsReady(pappso::UiMonitorInterface &monitor) override;
  void logReady(pappso::UiMonitorInterface &monitor) override;
  void parameterMapReady(pappso::UiMonitorInterface &monitor) override;
  void fastaFilesReady(pappso::UiMonitorInterface &monitor) override;
  void readSample(pappso::UiMonitorInterface &monitor) override;
  void sampleListStarted(pappso::UiMonitorInterface &monitor) override;
  void sampleListFinished(pappso::UiMonitorInterface &monitor) override;
  void readScan(pappso::UiMonitorInterface &monitor) override;
  void readPsm(pappso::UiMonitorInterface &monitor) override;
  void readProteinMap(pappso::UiMonitorInterface &monitor) override;


  protected:
  pappso::cbor::JsonStreamWriter *mp_jsonOutput;
};
} // namespace pappso::cbor::psm
