# - Try to find mbedTLS
# Once done this will define
#
# Read-Only variables
#  MBEDTLS_FOUND - system has mbedTLS
#  MBEDTLS_INCLUDE_DIR - the mbedTLS include directory
#  MBEDTLS_LIBRARY_DIR - the mbedTLS library directory
#  MBEDTLS_LIBRARIES - Link these to use mbedTLS
#  MBEDTLS_LIBRARY - path to mbedTLS library
#  MBEDX509_LIBRARY - path to mbedTLS X.509 library
#  MBEDCRYPTO_LIBRARY - path to mbedTLS Crypto library

include(FindPackageMessage)

FIND_PATH(MBEDTLS_INCLUDE_DIR mbedtls/version.h)

IF(MBEDTLS_INCLUDE_DIR AND MBEDTLS_LIBRARIES)
    # Already in cache, be silent
    SET(MBEDTLS_FIND_QUIETLY TRUE)
ENDIF()

FIND_LIBRARY(MBEDTLS_LIBRARY NAMES mbedtls libmbedtls libmbedx509)
FIND_LIBRARY(MBEDX509_LIBRARY NAMES mbedx509 libmbedx509)
FIND_LIBRARY(MBEDCRYPTO_LIBRARY NAMES mbedcrypto libmbedcrypto)

IF(MBEDTLS_INCLUDE_DIR AND MBEDTLS_LIBRARY AND MBEDX509_LIBRARY AND MBEDCRYPTO_LIBRARY)
    SET(MBEDTLS_FOUND TRUE)
ELSEIF(MBEDTLS_INCLUDE_DIR AND MBEDTLS_LIBRARY AND NOT MBEDX509_LIBRARY AND NOT MBEDCRYPTO_LIBRARY)
    SET(MBEDTLS_FOUND TRUE)
    SET(HACKY_OVPN_MBEDTLS TRUE)
ENDIF()

IF(MBEDTLS_FOUND)
  IF(NOT TARGET mbedTLS::mbedTLS AND EXISTS ${MBEDTLS_LIBRARY})
    add_library(mbedTLS::mbedTLS UNKNOWN IMPORTED)
    set_target_properties(mbedTLS::mbedTLS PROPERTIES
      INTERFACE_INCLUDE_DIRECTORIES "${MBEDTLS_INCLUDE_DIR}")
    set_target_properties(mbedTLS::mbedTLS PROPERTIES
      IMPORTED_LINK_INTERFACE_LANGUAGES "C"
      IMPORTED_LOCATION "${MBEDTLS_LIBRARY}")

    IF(HACKY_OVPN_MBEDTLS)
      SET(MBEDTLS_LIBRARIES ${MBEDTLS_LIBRARY})
    ELSE()
      SET(MBEDTLS_LIBRARIES ${MBEDTLS_LIBRARY} ${MBEDX509_LIBRARY} ${MBEDCRYPTO_LIBRARY})
      set_property( TARGET mbedTLS::mbedTLS APPEND PROPERTY INTERFACE_LINK_LIBRARIES ${MBEDX509_LIBRARY} )
      set_property( TARGET mbedTLS::mbedTLS APPEND PROPERTY INTERFACE_LINK_LIBRARIES ${MBEDCRYPTO_LIBRARY} )
    ENDIF()

    IF(NOT MBEDTLS_FIND_QUIETLY)
      SET(MBEDTLS_MSG "Found mbedTLS:\n")
      FILE(READ ${MBEDTLS_INCLUDE_DIR}/mbedtls/version.h MBEDTLSCONTENT)
      STRING(REGEX MATCH "MBEDTLS_VERSION_STRING +\"[0-9|.]+\"" MBEDTLSMATCH ${MBEDTLSCONTENT})
      IF (MBEDTLSMATCH)
        STRING(REGEX REPLACE "MBEDTLS_VERSION_STRING +\"([0-9|.]+)\"" "\\1" MBEDTLS_VERSION ${MBEDTLSMATCH})
        string(APPEND MBEDTLS_MSG "  version ${MBEDTLS_VERSION}\n")
      ENDIF(MBEDTLSMATCH)
      string(APPEND MBEDTLS_MSG "  TLS: ${MBEDTLS_LIBRARY}\n")
      string(APPEND MBEDTLS_MSG "  X509: ${MBEDX509_LIBRARY}\n")
      string(APPEND MBEDTLS_MSG "  Crypto: ${MBEDCRYPTO_LIBRARY}\n")
      FIND_PACKAGE_MESSAGE(MBEDTLS "${MBEDTLS_MSG}" "[${MBEDTLS_INCLUDE_DIR}][${MBEDTLS_LIBRARY}][${MBEDX509_LIBRARY}][${MBEDCRYPTO_LIBRARY}]")
    ENDIF(NOT MBEDTLS_FIND_QUIETLY)
  ENDIF(NOT TARGET mbedTLS::mbedTLS AND EXISTS ${MBEDTLS_LIBRARY})
ELSE(MBEDTLS_FOUND)
    IF(mbedTLS_FIND_REQUIRED)
        MESSAGE(FATAL_ERROR "Could not find mbedTLS")
    ENDIF(mbedTLS_FIND_REQUIRED)
ENDIF(MBEDTLS_FOUND)

MARK_AS_ADVANCED(
        MBEDTLS_INCLUDE_DIR
        MBEDTLS_LIBRARY_DIR
        MBEDTLS_LIBRARIES
        MBEDTLS_LIBRARY
        MBEDX509_LIBRARY
        MBEDCRYPTO_LIBRARY
)
