lib = File.expand_path("lib", __dir__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require "rqrcode_core/version"

Gem::Specification.new do |spec|
  spec.name = "rqrcode_core"
  spec.version = RQRCodeCore::VERSION
  spec.platform = Gem::Platform::RUBY
  spec.authors = ["Duncan Robertson"]
  spec.email = ["duncan@whomwah.com"]

  spec.summary = "A library to encode QR Codes"
  spec.description = <<~EOF
    rqrcode_core is a Ruby library for encoding QR Codes. The simple
    interface (with no runtime dependencies) allows you to create QR Code data structures.
  EOF
  spec.homepage = "https://github.com/whomwah/rqrcode_core"
  spec.license = "MIT"
  spec.metadata = {
    "bug_tracker_uri" => "https://github.com/whomwah/rqrcode_core/issues",
    "changelog_uri" => "https://github.com/whomwah/rqrcode_core/blob/main/CHANGELOG.md"
  }

  spec.files = Dir.chdir(File.expand_path(__dir__)) do
    `git ls-files -z`.split("\x0").select do |f|
      f.match(%r{^lib/}) || %w[LICENSE.txt README.md CHANGELOG.md].include?(f)
    end
  end
  spec.bindir = "exe"
  spec.executables = spec.files.grep(%r{^exe/}) { |f| File.basename(f) }
  spec.require_paths = ["lib"]

  spec.required_ruby_version = ">= 3.2"
  spec.add_development_dependency "benchmark-ips", "~> 2.0"
  spec.add_development_dependency "bundler", "~> 4.0"
  spec.add_development_dependency "memory_profiler", "~> 1.0"
  spec.add_development_dependency "minitest", "~> 6.0"
  spec.add_development_dependency "rake", "~> 13.3"
  spec.add_development_dependency "stackprof", "~> 0.2"
  spec.add_development_dependency "standard", "~> 1.41"
end
