/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef WALLPAPERINTERFACE_H
#define WALLPAPERINTERFACE_H

#include "universalinterface.h"
#include "workerobject.h"
#include <QObject>
#include <QtDBus>

class WallpaperInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Wallpaper")
    Q_PROPERTY(QString wallpaperMode READ getWallpaperMode)
    Q_PROPERTY(QString displayType READ getDisplayType)
    Q_PROPERTY(QString wallpaper READ getWallpaper)
    Q_PROPERTY(QStringList previewWallpapers READ getPreviewWallpapers)
    Q_PROPERTY(QStringList sourceWallpapers READ getSourceWallpapers)

public:
    WallpaperInterface();
    ~WallpaperInterface();
    QString getWallpaperMode(); // 背景
    QString getDisplayType();  // 显示方式
    QString getWallpaper();
    QStringList getPreviewWallpapers();
    QStringList getSourceWallpapers();

public Q_SLOTS:
    void setDisplayType(QString type);
    void setWallpaper(QString mode, QString data);
    void resetDefault();

private:
    void changeGlobalTheme();

private:
    QStringList previewWallpaperList;
    QStringList sourceWallpaperList;
    QString mWallpaperMode;
    QString mDisplayType;
    QString mWallpaper;

Q_SIGNALS:
    void changed(QString key);
};

#endif // WALLPAPERINTERFACE_H
