/* SPDX-License-Identifier: GPL-2.0-or-later */
/* This file was generated by: ./scripts/crypto/gen-hash-testvecs.py sha224 */

static const struct {
	size_t data_len;
	u8 digest[SHA224_DIGEST_SIZE];
} hash_testvecs[] = {
	{
		.data_len = 0,
		.digest = {
			0xd1, 0x4a, 0x02, 0x8c, 0x2a, 0x3a, 0x2b, 0xc9,
			0x47, 0x61, 0x02, 0xbb, 0x28, 0x82, 0x34, 0xc4,
			0x15, 0xa2, 0xb0, 0x1f, 0x82, 0x8e, 0xa6, 0x2a,
			0xc5, 0xb3, 0xe4, 0x2f,
		},
	},
	{
		.data_len = 1,
		.digest = {
			0xe3, 0x4d, 0x79, 0x17, 0x75, 0x35, 0xdc, 0xd2,
			0x27, 0xc9, 0x9d, 0x0b, 0x90, 0x0f, 0x21, 0x5d,
			0x95, 0xfb, 0x9c, 0x6d, 0xa8, 0xec, 0x19, 0x15,
			0x12, 0xef, 0xf5, 0x0f,
		},
	},
	{
		.data_len = 2,
		.digest = {
			0x81, 0xc7, 0x60, 0x0d, 0x6d, 0x13, 0x75, 0x70,
			0x4b, 0xc0, 0xab, 0xea, 0x04, 0xe3, 0x78, 0x7e,
			0x73, 0xb9, 0x0f, 0xb6, 0xae, 0x90, 0xf3, 0x94,
			0xb2, 0x56, 0xda, 0xc8,
		},
	},
	{
		.data_len = 3,
		.digest = {
			0x24, 0xf0, 0x8c, 0x6e, 0x9d, 0xd6, 0x06, 0x80,
			0x0a, 0x03, 0xee, 0x9b, 0x33, 0xec, 0x83, 0x42,
			0x2c, 0x8b, 0xe7, 0xc7, 0xc6, 0x04, 0xfb, 0xc6,
			0xa3, 0x3a, 0x4d, 0xc9,
		},
	},
	{
		.data_len = 16,
		.digest = {
			0x1c, 0x08, 0xa8, 0x55, 0x8f, 0xc6, 0x0a, 0xea,
			0x2f, 0x1b, 0x54, 0xff, 0x8d, 0xd2, 0xa3, 0xc7,
			0x42, 0xc2, 0x93, 0x3d, 0x73, 0x18, 0x84, 0xba,
			0x75, 0x49, 0x34, 0xfd,
		},
	},
	{
		.data_len = 32,
		.digest = {
			0x45, 0xdd, 0xb5, 0xf0, 0x3c, 0xda, 0xe6, 0xd4,
			0x6c, 0x86, 0x91, 0x29, 0x11, 0x2f, 0x88, 0x7d,
			0xd8, 0x3c, 0xa3, 0xd6, 0xdd, 0x1e, 0xac, 0x98,
			0xff, 0xf0, 0x14, 0x69,
		},
	},
	{
		.data_len = 48,
		.digest = {
			0x0b, 0xfb, 0x71, 0x4c, 0x06, 0x7a, 0xd5, 0x89,
			0x76, 0x0a, 0x43, 0x8b, 0x2b, 0x47, 0x12, 0x56,
			0xa7, 0x64, 0x33, 0x1d, 0xd3, 0x44, 0x17, 0x95,
			0x23, 0xe7, 0x53, 0x01,
		},
	},
	{
		.data_len = 49,
		.digest = {
			0xc4, 0xae, 0x9c, 0x33, 0xd5, 0x1d, 0xf4, 0xa7,
			0xfd, 0xb7, 0xd4, 0x6b, 0xc3, 0xeb, 0xa8, 0xbf,
			0xfb, 0x07, 0x89, 0x4b, 0x07, 0x15, 0x22, 0xec,
			0xe1, 0x45, 0x84, 0xba,
		},
	},
	{
		.data_len = 63,
		.digest = {
			0xad, 0x01, 0x34, 0x2a, 0xe2, 0x3b, 0x58, 0x06,
			0x9f, 0x20, 0xc8, 0xfb, 0xf3, 0x20, 0x82, 0xa6,
			0x9f, 0xee, 0x7a, 0xbe, 0xdf, 0xf3, 0x5d, 0x57,
			0x9b, 0xce, 0x79, 0x96,
		},
	},
	{
		.data_len = 64,
		.digest = {
			0xa7, 0xa6, 0x47, 0xf7, 0xed, 0x2a, 0xe5, 0xe3,
			0xc0, 0x1e, 0x7b, 0x40, 0xe4, 0xf7, 0x40, 0x65,
			0x42, 0xc1, 0x6f, 0x7d, 0x8d, 0x0d, 0x17, 0x4f,
			0xd3, 0xbc, 0x0d, 0x85,
		},
	},
	{
		.data_len = 65,
		.digest = {
			0xc4, 0x9c, 0xb5, 0x6a, 0x01, 0x2d, 0x10, 0xa9,
			0x5f, 0xa4, 0x5a, 0xe1, 0xba, 0x40, 0x12, 0x09,
			0x7b, 0xea, 0xdb, 0xa6, 0x7b, 0xcb, 0x56, 0xf0,
			0xfd, 0x5b, 0xe2, 0xe7,
		},
	},
	{
		.data_len = 127,
		.digest = {
			0x14, 0xda, 0x0e, 0x01, 0xca, 0x78, 0x7d, 0x2d,
			0x85, 0xa3, 0xca, 0x0e, 0x80, 0xf9, 0x95, 0x10,
			0xa1, 0x7b, 0xa5, 0xaa, 0xfc, 0x95, 0x05, 0x08,
			0x53, 0xda, 0x52, 0xee,
		},
	},
	{
		.data_len = 128,
		.digest = {
			0xa5, 0x24, 0xc4, 0x54, 0xe1, 0x50, 0xab, 0xee,
			0x22, 0xc1, 0xa7, 0x27, 0x15, 0x2c, 0x6f, 0xf7,
			0x4c, 0x31, 0xe5, 0x15, 0x25, 0x4e, 0x71, 0xc6,
			0x7e, 0xa0, 0x11, 0x5d,
		},
	},
	{
		.data_len = 129,
		.digest = {
			0x73, 0xd0, 0x8c, 0xce, 0xed, 0xed, 0x9f, 0xaa,
			0x21, 0xaf, 0xa2, 0x08, 0x80, 0x16, 0x15, 0x59,
			0x3f, 0x1d, 0x7f, 0x0a, 0x79, 0x3d, 0x7b, 0x58,
			0xf8, 0xc8, 0x5c, 0x27,
		},
	},
	{
		.data_len = 256,
		.digest = {
			0x31, 0xa7, 0xa1, 0xca, 0x49, 0x72, 0x75, 0xcc,
			0x6e, 0x02, 0x9e, 0xad, 0xea, 0x86, 0x5c, 0x91,
			0x02, 0xe4, 0xc9, 0xf9, 0xd3, 0x9e, 0x74, 0x50,
			0xd8, 0x43, 0x6b, 0x85,
		},
	},
	{
		.data_len = 511,
		.digest = {
			0x40, 0x60, 0x8b, 0xb0, 0x03, 0xa9, 0x75, 0xab,
			0x2d, 0x5b, 0x20, 0x9a, 0x05, 0x72, 0xb7, 0xa8,
			0xce, 0xf2, 0x4f, 0x66, 0x62, 0xe3, 0x7e, 0x24,
			0xd6, 0xe2, 0xea, 0xfa,
		},
	},
	{
		.data_len = 513,
		.digest = {
			0x4f, 0x5f, 0x9f, 0x1e, 0xb3, 0x66, 0x81, 0xdb,
			0x41, 0x5d, 0x65, 0x97, 0x00, 0x8d, 0xdc, 0x62,
			0x03, 0xb0, 0x4d, 0x6b, 0x5c, 0x7f, 0x1e, 0xa0,
			0xfe, 0xfc, 0x0e, 0xb8,
		},
	},
	{
		.data_len = 1000,
		.digest = {
			0x08, 0xa8, 0xa1, 0xc0, 0xd8, 0xf9, 0xb4, 0xaa,
			0x53, 0x22, 0xa1, 0x73, 0x0b, 0x45, 0xa0, 0x20,
			0x72, 0xf3, 0xa9, 0xbc, 0x51, 0xd0, 0x20, 0x79,
			0x69, 0x97, 0xf7, 0xe3,
		},
	},
	{
		.data_len = 3333,
		.digest = {
			0xe8, 0x60, 0x5f, 0xb9, 0x12, 0xe1, 0x6b, 0x24,
			0xc5, 0xe8, 0x43, 0xa9, 0x5c, 0x3f, 0x65, 0xed,
			0xbe, 0xfd, 0x77, 0xf5, 0x47, 0xf2, 0x75, 0x21,
			0xc2, 0x8f, 0x54, 0x8f,
		},
	},
	{
		.data_len = 4096,
		.digest = {
			0xc7, 0xdf, 0x50, 0x16, 0x10, 0x01, 0xb7, 0xdf,
			0x34, 0x1d, 0x18, 0xa2, 0xd5, 0xad, 0x1f, 0x50,
			0xf7, 0xa8, 0x9a, 0x72, 0xfb, 0xfd, 0xd9, 0x1c,
			0x57, 0xac, 0x08, 0x97,
		},
	},
	{
		.data_len = 4128,
		.digest = {
			0xdf, 0x16, 0x76, 0x7f, 0xc0, 0x16, 0x84, 0x63,
			0xac, 0xcf, 0xd0, 0x78, 0x1e, 0x96, 0x67, 0xc5,
			0x3c, 0x06, 0xe9, 0xdb, 0x6e, 0x7d, 0xd0, 0x07,
			0xaa, 0xb1, 0x56, 0xc9,
		},
	},
	{
		.data_len = 4160,
		.digest = {
			0x49, 0xec, 0x5c, 0x18, 0xd7, 0x5b, 0xda, 0xed,
			0x5b, 0x59, 0xde, 0x09, 0x34, 0xb2, 0x49, 0x43,
			0x62, 0x6a, 0x0a, 0x63, 0x6a, 0x51, 0x08, 0x37,
			0x8c, 0xb6, 0x29, 0x84,
		},
	},
	{
		.data_len = 4224,
		.digest = {
			0x3d, 0xc2, 0xc8, 0x43, 0xcf, 0xb7, 0x33, 0x14,
			0x04, 0x93, 0xed, 0xe2, 0xcd, 0x8a, 0x69, 0x5c,
			0x5a, 0xd5, 0x9b, 0x52, 0xdf, 0x48, 0xa7, 0xaa,
			0x28, 0x2b, 0x5d, 0x27,
		},
	},
	{
		.data_len = 16384,
		.digest = {
			0xa7, 0xaf, 0xda, 0x92, 0xe2, 0xe7, 0x61, 0xdc,
			0xa1, 0x32, 0x53, 0x2a, 0x3f, 0x41, 0x5c, 0x7e,
			0xc9, 0x89, 0xda, 0x1c, 0xf7, 0x8d, 0x00, 0xbd,
			0x21, 0x73, 0xb1, 0x69,
		},
	},
};

static const u8 hash_testvec_consolidated[SHA224_DIGEST_SIZE] = {
	0x9e, 0xb8, 0x82, 0xab, 0x83, 0x37, 0xe4, 0x63,
	0x84, 0xee, 0x21, 0x15, 0xc2, 0xbb, 0xa3, 0x17,
	0x8f, 0xc4, 0x99, 0x33, 0xa0, 0x2c, 0x9f, 0xec,
	0xca, 0xd0, 0xf3, 0x73,
};

static const u8 hmac_testvec_consolidated[SHA224_DIGEST_SIZE] = {
	0x66, 0x34, 0x79, 0x92, 0x47, 0x0e, 0xcd, 0x70,
	0xb0, 0x8b, 0x91, 0xcb, 0x94, 0x2f, 0x67, 0x65,
	0x2f, 0xc9, 0xd2, 0x91, 0x32, 0xaf, 0xf7, 0x5f,
	0xb6, 0x01, 0x5b, 0xf2,
};
