// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{DBusConnection, DBusObjectManager, DBusObjectSkeleton, ffi};
use glib::{
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GDBusObjectManagerServer")]
    pub struct DBusObjectManagerServer(Object<ffi::GDBusObjectManagerServer, ffi::GDBusObjectManagerServerClass>) @implements DBusObjectManager;

    match fn {
        type_ => || ffi::g_dbus_object_manager_server_get_type(),
    }
}

impl DBusObjectManagerServer {
    pub const NONE: Option<&'static DBusObjectManagerServer> = None;

    #[doc(alias = "g_dbus_object_manager_server_new")]
    pub fn new(object_path: &str) -> DBusObjectManagerServer {
        unsafe {
            from_glib_full(ffi::g_dbus_object_manager_server_new(
                object_path.to_glib_none().0,
            ))
        }
    }
}

pub trait DBusObjectManagerServerExt: IsA<DBusObjectManagerServer> + 'static {
    #[doc(alias = "g_dbus_object_manager_server_export")]
    fn export(&self, object: &impl IsA<DBusObjectSkeleton>) {
        unsafe {
            ffi::g_dbus_object_manager_server_export(
                self.as_ref().to_glib_none().0,
                object.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_object_manager_server_export_uniquely")]
    fn export_uniquely(&self, object: &impl IsA<DBusObjectSkeleton>) {
        unsafe {
            ffi::g_dbus_object_manager_server_export_uniquely(
                self.as_ref().to_glib_none().0,
                object.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_object_manager_server_get_connection")]
    #[doc(alias = "get_connection")]
    fn connection(&self) -> Option<DBusConnection> {
        unsafe {
            from_glib_full(ffi::g_dbus_object_manager_server_get_connection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_server_is_exported")]
    fn is_exported(&self, object: &impl IsA<DBusObjectSkeleton>) -> bool {
        unsafe {
            from_glib(ffi::g_dbus_object_manager_server_is_exported(
                self.as_ref().to_glib_none().0,
                object.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "g_dbus_object_manager_server_set_connection")]
    #[doc(alias = "connection")]
    fn set_connection(&self, connection: Option<&DBusConnection>) {
        unsafe {
            ffi::g_dbus_object_manager_server_set_connection(
                self.as_ref().to_glib_none().0,
                connection.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_object_manager_server_unexport")]
    fn unexport(&self, object_path: &str) -> bool {
        unsafe {
            from_glib(ffi::g_dbus_object_manager_server_unexport(
                self.as_ref().to_glib_none().0,
                object_path.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "connection")]
    fn connect_connection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_connection_trampoline<
            P: IsA<DBusObjectManagerServer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GDBusObjectManagerServer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(DBusObjectManagerServer::from_glib_borrow(this).unsafe_cast_ref())
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::connection".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_connection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<DBusObjectManagerServer>> DBusObjectManagerServerExt for O {}
