/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright 2009--2026 by Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes
#include <QList>


/////////////////////// Local includes
#include "MsXpS/export-import-config.h"

#include "MsXpS/libXpertMassCore/Polymer.hpp"
#include "MsXpS/libXpertMassCore/Monomer.hpp"
#include "MsXpS/libXpertMassCore/Modif.hpp"
#include "MsXpS/libXpertMassCore/ChemicalGroup.hpp"
#include "MsXpS/libXpertMassCore/PropListHolder.hpp"

namespace MsXpS
{
namespace libXpertMassCore
{


class DECLSPEC PkaPhPi: public PropListHolder
{
  public:
  PkaPhPi(PolChemDefCstSPtr pol_chem_def_csp,
          PolymerCstQSPtr polymer_cqsp,
          const CalcOptions &calc_options);

  ~PkaPhPi();

  void setPolChemDefCstSPtr(PolChemDefCstSPtr pol_chem_def_csp);
  PolChemDefCstSPtr getPolChemDefCstSPtr() const;

  void setMonomers(std::vector<MonomerCstSPtr> &&monomers);
  void setMonomers(std::vector<MonomerSPtr> &&monomers);
  void setMonomers(std::vector<MonomerCstSPtr> &monomers);

  const std::vector<MonomerCstSPtr> &getMonomersCstRef() const;

  void setModifs(std::vector<ModifCstSPtr> &&modifs);
  void setModifs(std::vector<ModifSPtr> &&modifs);
  void setModifs(std::vector<ModifCstSPtr> &modifs);
  const std::vector<ModifCstSPtr> &getModifs() const;

  void setPh(double);
  double ph();

  double pi();
  double positiveCharges();
  double negativeCharges();

  void setCalcOptions(const CalcOptions &);

  void setMonomerList(QList<Monomer *> *);
  void setModifList(QList<Modif *> *);

  int calculateCharges();
  int calculatePi();

  double calculateChargeRatio(double, bool);

  int accountPolymerEndModif(Enums::ChemicalEntity polymer_chem_ent,
                             const ChemicalGroup &chemical_group);
  int accountMonomerModif(const Monomer &, ChemicalGroup &);

  using PropListHolder::operator=;

  protected:
  PolChemDefCstSPtr mcsp_polChemDef = nullptr;

  std::vector<MonomerCstSPtr> m_monomers;
  std::vector<ModifCstSPtr> m_modifs;

  double m_ph = 7;
  double m_pi = 7;

  PolymerCstQSPtr mcsp_polymer;
  CalcOptions m_calcOptions;

  double m_positiveCharges = 0;
  double m_negativeCharges = 0;

  bool *mp_aborted = nullptr;
  int *mp_progress = nullptr;
};

} // namespace libXpertMassCore

} // namespace MsXpS
