
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <BRepTools_Modification.hxx>
#include <BRepTools_Modifier.hxx>
#include <ShapeBuild_ReShape.hxx>
#include <ShapeCustom_RestrictionParameters.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeCustom_RestrictionParameters.hxx>
#include <TopoDS_Face.hxx>
#include <Geom_Surface.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Edge.hxx>
#include <Geom_Curve.hxx>
#include <Geom2d_Curve.hxx>
#include <TopoDS_Vertex.hxx>
#include <gp_Pnt.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <Geom_Surface.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Edge.hxx>
#include <Geom_Curve.hxx>
#include <TopoDS_Vertex.hxx>
#include <gp_Pnt.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <Geom_Surface.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Edge.hxx>
#include <Geom_Curve.hxx>
#include <TopoDS_Vertex.hxx>
#include <gp_Pnt.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_Line.hxx>
#include <Geom2d_Curve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <Geom_Surface.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Edge.hxx>
#include <Geom_Curve.hxx>
#include <TopoDS_Vertex.hxx>
#include <gp_Pnt.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <ShapeExtend_BasicMsgRegistrator.hxx>
#include <TopoDS_Shape.hxx>
#include <Message_Msg.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <Geom_Surface.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Edge.hxx>
#include <Geom_Curve.hxx>
#include <TopoDS_Vertex.hxx>
#include <gp_Pnt.hxx>
#include <Geom2d_Curve.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TopoDS_Face.hxx>
#include <Geom_Surface.hxx>
#include <TopLoc_Location.hxx>
#include <TopoDS_Edge.hxx>
#include <Geom_Curve.hxx>
#include <TopoDS_Vertex.hxx>
#include <Geom2d_Curve.hxx>

// module includes
#include <ShapeCustom.hxx>
#include <ShapeCustom_BSplineRestriction.hxx>
#include <ShapeCustom_ConvertToBSpline.hxx>
#include <ShapeCustom_ConvertToRevolution.hxx>
#include <ShapeCustom_Curve.hxx>
#include <ShapeCustom_Curve2d.hxx>
#include <ShapeCustom_DirectModification.hxx>
#include <ShapeCustom_Modification.hxx>
#include <ShapeCustom_RestrictionParameters.hxx>
#include <ShapeCustom_Surface.hxx>
#include <ShapeCustom_SweptToElementary.hxx>
#include <ShapeCustom_TrsfModification.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_ShapeCustom(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("ShapeCustom"));
py::object klass;

//Python trampoline classes
    class Py_ShapeCustom_Modification : public ShapeCustom_Modification{
    public:
        using ShapeCustom_Modification::ShapeCustom_Modification;


        // public pure virtual

        Standard_Boolean NewSurface(const TopoDS_Face & F,opencascade::handle<Geom_Surface> & S,TopLoc_Location & L,Standard_Real & Tol,Standard_Boolean & RevWires,Standard_Boolean & RevFace) override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,BRepTools_Modification,NewSurface,F,S,L,Tol,RevWires,RevFace) };
        Standard_Boolean NewCurve(const TopoDS_Edge & E,opencascade::handle<Geom_Curve> & C,TopLoc_Location & L,Standard_Real & Tol) override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,BRepTools_Modification,NewCurve,E,C,L,Tol) };
        Standard_Boolean NewPoint(const TopoDS_Vertex & V,gp_Pnt & P,Standard_Real & Tol) override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,BRepTools_Modification,NewPoint,V,P,Tol) };
        Standard_Boolean NewCurve2d(const TopoDS_Edge & E,const TopoDS_Face & F,const TopoDS_Edge & NewE,const TopoDS_Face & NewF,opencascade::handle<Geom2d_Curve> & C,Standard_Real & Tol) override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,BRepTools_Modification,NewCurve2d,E,F,NewE,NewF,C,Tol) };
        Standard_Boolean NewParameter(const TopoDS_Vertex & V,const TopoDS_Edge & E,Standard_Real & P,Standard_Real & Tol) override { PYBIND11_OVERLOAD_PURE(Standard_Boolean,BRepTools_Modification,NewParameter,V,E,P,Tol) };
        GeomAbs_Shape Continuity(const TopoDS_Edge & E,const TopoDS_Face & F1,const TopoDS_Face & F2,const TopoDS_Edge & NewE,const TopoDS_Face & NewF1,const TopoDS_Face & NewF2) override { PYBIND11_OVERLOAD_PURE(GeomAbs_Shape,BRepTools_Modification,Continuity,E,F1,F2,NewE,NewF1,NewF2) };

        // protected pure virtual


        // private pure virtual

    };

// classes

    // Class ShapeCustom from ./opencascade/ShapeCustom.hxx
    klass = m.attr("ShapeCustom");

    // default constructor
    register_default_constructor<ShapeCustom , shared_ptr<ShapeCustom>>(m,"ShapeCustom");

    // nested enums

    static_cast<py::class_<ShapeCustom , shared_ptr<ShapeCustom>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("ApplyModifier_s",
                    (TopoDS_Shape (*)( const TopoDS_Shape & ,  const opencascade::handle<BRepTools_Modification> & ,  NCollection_DataMap<TopoDS_Shape, TopoDS_Shape, TopTools_ShapeMapHasher> & ,  BRepTools_Modifier & ,  const Message_ProgressRange & ,  const opencascade::handle<ShapeBuild_ReShape> &  ) ) static_cast<TopoDS_Shape (*)( const TopoDS_Shape & ,  const opencascade::handle<BRepTools_Modification> & ,  NCollection_DataMap<TopoDS_Shape, TopoDS_Shape, TopTools_ShapeMapHasher> & ,  BRepTools_Modifier & ,  const Message_ProgressRange & ,  const opencascade::handle<ShapeBuild_ReShape> &  ) >(&ShapeCustom::ApplyModifier),
                    R"#(Applies modifier to shape and checks sharing in the case assemblies.)#"  , py::arg("S"),  py::arg("M"),  py::arg("context"),  py::arg("MD"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( )),  py::arg("aReShape")=static_cast<const opencascade::handle<ShapeBuild_ReShape> &>(NULL)
          )
        .def_static("DirectFaces_s",
                    (TopoDS_Shape (*)( const TopoDS_Shape &  ) ) static_cast<TopoDS_Shape (*)( const TopoDS_Shape &  ) >(&ShapeCustom::DirectFaces),
                    R"#(Returns a new shape without indirect surfaces.)#"  , py::arg("S")
          )
        .def_static("ScaleShape_s",
                    (TopoDS_Shape (*)( const TopoDS_Shape & ,  const Standard_Real  ) ) static_cast<TopoDS_Shape (*)( const TopoDS_Shape & ,  const Standard_Real  ) >(&ShapeCustom::ScaleShape),
                    R"#(Returns a new shape which is scaled original)#"  , py::arg("S"),  py::arg("scale")
          )
        .def_static("BSplineRestriction_s",
                    (TopoDS_Shape (*)( const TopoDS_Shape & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const GeomAbs_Shape ,  const GeomAbs_Shape ,  const Standard_Boolean ,  const Standard_Boolean ,  const opencascade::handle<ShapeCustom_RestrictionParameters> &  ) ) static_cast<TopoDS_Shape (*)( const TopoDS_Shape & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const GeomAbs_Shape ,  const GeomAbs_Shape ,  const Standard_Boolean ,  const Standard_Boolean ,  const opencascade::handle<ShapeCustom_RestrictionParameters> &  ) >(&ShapeCustom::BSplineRestriction),
                    R"#(Returns a new shape with all surfaces, curves and pcurves which type is BSpline/Bezier or based on them converted having Degree less than <MaxDegree> or number of spans less than <NbMaxSegment> in dependence on parameter priority <Degree>. <GmaxDegree> and <GMaxSegments> are maximum possible degree and number of spans correspondingly. These values will be used in those cases when approximation with specified parameters is impossible and one of GmaxDegree or GMaxSegments is selected in dependence on priority. Note that even if approximation is impossible with <GMaxDegree> then number of spans can exceed specified <GMaxSegment> <Rational> specifies if to convert Rational BSpline/Bezier into polynomial B-Spline. If flags ConvOffSurf,ConvOffCurve3d,ConvOffCurve2d are Standard_True there are means that Offset surfaces , Offset curves 3d and Offset curves 2d are converted to BSPline correspondingly.)#"  , py::arg("S"),  py::arg("Tol3d"),  py::arg("Tol2d"),  py::arg("MaxDegree"),  py::arg("MaxNbSegment"),  py::arg("Continuity3d"),  py::arg("Continuity2d"),  py::arg("Degree"),  py::arg("Rational"),  py::arg("aParameters")
          )
        .def_static("ConvertToRevolution_s",
                    (TopoDS_Shape (*)( const TopoDS_Shape &  ) ) static_cast<TopoDS_Shape (*)( const TopoDS_Shape &  ) >(&ShapeCustom::ConvertToRevolution),
                    R"#(Returns a new shape with all elementary periodic surfaces converted to Geom_SurfaceOfRevolution)#"  , py::arg("S")
          )
        .def_static("SweptToElementary_s",
                    (TopoDS_Shape (*)( const TopoDS_Shape &  ) ) static_cast<TopoDS_Shape (*)( const TopoDS_Shape &  ) >(&ShapeCustom::SweptToElementary),
                    R"#(Returns a new shape with all surfaces of revolution and linear extrusion convert to elementary periodic surfaces)#"  , py::arg("S")
          )
        .def_static("ConvertToBSpline_s",
                    (TopoDS_Shape (*)( const TopoDS_Shape & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) ) static_cast<TopoDS_Shape (*)( const TopoDS_Shape & ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean ,  const Standard_Boolean  ) >(&ShapeCustom::ConvertToBSpline),
                    R"#(Returns a new shape with all surfaces of linear extrusion, revolution, offset, and planar surfaces converted according to flags to Geom_BSplineSurface (with same parameterisation).)#"  , py::arg("S"),  py::arg("extrMode"),  py::arg("revolMode"),  py::arg("offsetMode"),  py::arg("planeMode")=static_cast<const Standard_Boolean>(Standard_False)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class ShapeCustom_Curve from ./opencascade/ShapeCustom_Curve.hxx
    klass = m.attr("ShapeCustom_Curve");


    // nested enums

    static_cast<py::class_<ShapeCustom_Curve , shared_ptr<ShapeCustom_Curve>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Geom_Curve> & >()  , py::arg("C") )
    // custom constructors
    // methods
        .def("Init",
             (void (ShapeCustom_Curve::*)( const opencascade::handle<Geom_Curve> &  ) ) static_cast<void (ShapeCustom_Curve::*)( const opencascade::handle<Geom_Curve> &  ) >(&ShapeCustom_Curve::Init),
             R"#(None)#"  , py::arg("C")
          )
        .def("ConvertToPeriodic",
             (opencascade::handle<Geom_Curve> (ShapeCustom_Curve::*)( const Standard_Boolean ,  const Standard_Real  ) ) static_cast<opencascade::handle<Geom_Curve> (ShapeCustom_Curve::*)( const Standard_Boolean ,  const Standard_Real  ) >(&ShapeCustom_Curve::ConvertToPeriodic),
             R"#(Tries to convert the Curve to the Periodic form Returns the resulting curve Works only if the Curve is BSpline and is closed with Precision::Confusion() Else, or in case of failure, returns a Null Handle)#"  , py::arg("substitute"),  py::arg("preci")=static_cast<const Standard_Real>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class ShapeCustom_Curve2d from ./opencascade/ShapeCustom_Curve2d.hxx
    klass = m.attr("ShapeCustom_Curve2d");

    // default constructor
    register_default_constructor<ShapeCustom_Curve2d , shared_ptr<ShapeCustom_Curve2d>>(m,"ShapeCustom_Curve2d");

    // nested enums

    static_cast<py::class_<ShapeCustom_Curve2d , shared_ptr<ShapeCustom_Curve2d>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("IsLinear_s",
                    (Standard_Boolean (*)(  const NCollection_Array1<gp_Pnt2d> & ,  const Standard_Real ,  Standard_Real &  ) ) static_cast<Standard_Boolean (*)(  const NCollection_Array1<gp_Pnt2d> & ,  const Standard_Real ,  Standard_Real &  ) >(&ShapeCustom_Curve2d::IsLinear),
                    R"#(Check if poleses is in the plane with given precision Returns false if no.)#"  , py::arg("thePoles"),  py::arg("theTolerance"),  py::arg("theDeviation")
          )
        .def_static("ConvertToLine2d_s",
                    (opencascade::handle<Geom2d_Line> (*)( const opencascade::handle<Geom2d_Curve> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<opencascade::handle<Geom2d_Line> (*)( const opencascade::handle<Geom2d_Curve> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  Standard_Real & ,  Standard_Real & ,  Standard_Real &  ) >(&ShapeCustom_Curve2d::ConvertToLine2d),
                    R"#(Try to convert BSpline2d or Bezier2d to line 2d only if it is linear. Recalculate first and last parameters. Returns line2d or null curve2d.)#"  , py::arg("theCurve"),  py::arg("theFirstIn"),  py::arg("theLastIn"),  py::arg("theTolerance"),  py::arg("theNewFirst"),  py::arg("theNewLast"),  py::arg("theDeviation")
          )
        .def_static("SimplifyBSpline2d_s",
                    (Standard_Boolean (*)( opencascade::handle<Geom2d_BSplineCurve> & ,  const Standard_Real  ) ) static_cast<Standard_Boolean (*)( opencascade::handle<Geom2d_BSplineCurve> & ,  const Standard_Real  ) >(&ShapeCustom_Curve2d::SimplifyBSpline2d),
                    R"#(Try to remove knots from bspline where local derivatives are the same. Remove knots with given precision. Returns false if Bsplien was not modified)#"  , py::arg("theBSpline2d"),  py::arg("theTolerance")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class ShapeCustom_Modification from ./opencascade/ShapeCustom_Modification.hxx
    klass = m.attr("ShapeCustom_Modification");


    // nested enums

    static_cast<py::class_<ShapeCustom_Modification ,opencascade::handle<ShapeCustom_Modification> ,Py_ShapeCustom_Modification , BRepTools_Modification >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("SetMsgRegistrator",
             (void (ShapeCustom_Modification::*)( const opencascade::handle<ShapeExtend_BasicMsgRegistrator> &  ) ) static_cast<void (ShapeCustom_Modification::*)( const opencascade::handle<ShapeExtend_BasicMsgRegistrator> &  ) >(&ShapeCustom_Modification::SetMsgRegistrator),
             R"#(Sets message registrator)#"  , py::arg("msgreg")
          )
        .def("MsgRegistrator",
             (opencascade::handle<ShapeExtend_BasicMsgRegistrator> (ShapeCustom_Modification::*)() const) static_cast<opencascade::handle<ShapeExtend_BasicMsgRegistrator> (ShapeCustom_Modification::*)() const>(&ShapeCustom_Modification::MsgRegistrator),
             R"#(Returns message registrator)#" 
          )
        .def("SendMsg",
             (void (ShapeCustom_Modification::*)( const TopoDS_Shape & ,  const Message_Msg & ,  const Message_Gravity  ) const) static_cast<void (ShapeCustom_Modification::*)( const TopoDS_Shape & ,  const Message_Msg & ,  const Message_Gravity  ) const>(&ShapeCustom_Modification::SendMsg),
             R"#(Sends a message to be attached to the shape. Calls corresponding message of message registrator.)#"  , py::arg("shape"),  py::arg("message"),  py::arg("gravity")=static_cast<const Message_Gravity>(Message_Info)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_Modification::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_Modification::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_Modification::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_Modification::*)() const>(&ShapeCustom_Modification::DynamicType),
             R"#(None)#"
             
         )
;

    // Class ShapeCustom_RestrictionParameters from ./opencascade/ShapeCustom_RestrictionParameters.hxx
    klass = m.attr("ShapeCustom_RestrictionParameters");


    // nested enums

    static_cast<py::class_<ShapeCustom_RestrictionParameters ,opencascade::handle<ShapeCustom_RestrictionParameters>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_RestrictionParameters::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_RestrictionParameters::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def_property("GMaxDegree",
                     [](ShapeCustom_RestrictionParameters& self){return self.GMaxDegree();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Integer  val){self.GMaxDegree() = val;},                      R"#(Returns (modifiable) maximal degree of approximation.)#"
         )
       .def_property("GMaxSeg",
                     [](ShapeCustom_RestrictionParameters& self){return self.GMaxSeg();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Integer  val){self.GMaxSeg() = val;},                      R"#(Returns (modifiable) maximal number of spans of approximation.)#"
         )
       .def_property("ConvertPlane",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertPlane();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertPlane() = val;},                      R"#(Sets flag for define if Plane converted to BSpline surface.)#"
         )
       .def_property("ConvertBezierSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertBezierSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertBezierSurf() = val;},                      R"#(Sets flag for define if Bezier surface converted to BSpline surface.)#"
         )
       .def_property("ConvertRevolutionSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertRevolutionSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertRevolutionSurf() = val;},                      R"#(Sets flag for define if surface of Revolution converted to BSpline surface.)#"
         )
       .def_property("ConvertExtrusionSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertExtrusionSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertExtrusionSurf() = val;},                      R"#(Sets flag for define if surface of LinearExtrusion converted to BSpline surface.)#"
         )
       .def_property("ConvertOffsetSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertOffsetSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertOffsetSurf() = val;},                      R"#(Sets flag for define if Offset surface converted to BSpline surface.)#"
         )
       .def_property("ConvertCylindricalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertCylindricalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertCylindricalSurf() = val;},                      R"#(Sets flag for define if cylindrical surface converted to BSpline surface.)#"
         )
       .def_property("ConvertConicalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertConicalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertConicalSurf() = val;},                      R"#(Sets flag for define if conical surface converted to BSpline surface.)#"
         )
       .def_property("ConvertToroidalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertToroidalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertToroidalSurf() = val;},                      R"#(Sets flag for define if toroidal surface converted to BSpline surface.)#"
         )
       .def_property("ConvertSphericalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertSphericalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertSphericalSurf() = val;},                      R"#(Sets flag for define if spherical surface converted to BSpline surface.)#"
         )
       .def_property("SegmentSurfaceMode",
                     [](ShapeCustom_RestrictionParameters& self){return self.SegmentSurfaceMode();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.SegmentSurfaceMode() = val;},                      R"#(Sets Segment mode for surface. If Segment is True surface is approximated in the bondaries of face lying on this surface.)#"
         )
       .def_property("ConvertCurve3d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertCurve3d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertCurve3d() = val;},                      R"#(Sets flag for define if 3d curve converted to BSpline curve.)#"
         )
       .def_property("ConvertOffsetCurv3d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertOffsetCurv3d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertOffsetCurv3d() = val;},                      R"#(Sets flag for define if Offset curve3d converted to BSpline surface.)#"
         )
       .def_property("ConvertCurve2d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertCurve2d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertCurve2d() = val;},                      R"#(Returns (modifiable) flag for define if 2d curve converted to BSpline curve.)#"
         )
       .def_property("ConvertOffsetCurv2d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertOffsetCurv2d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertOffsetCurv2d() = val;},                      R"#(Returns (modifiable) flag for define if Offset curve2d converted to BSpline surface.)#"
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_RestrictionParameters::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_RestrictionParameters::*)() const>(&ShapeCustom_RestrictionParameters::DynamicType),
             R"#(None)#"
             
         )
       .def_property("GMaxDegree",
                     [](ShapeCustom_RestrictionParameters& self){return self.GMaxDegree();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Integer  val){self.GMaxDegree() = val;},                      R"#(Returns (modifiable) maximal degree of approximation.)#"
         )
       .def_property("GMaxSeg",
                     [](ShapeCustom_RestrictionParameters& self){return self.GMaxSeg();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Integer  val){self.GMaxSeg() = val;},                      R"#(Returns (modifiable) maximal number of spans of approximation.)#"
         )
       .def_property("ConvertPlane",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertPlane();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertPlane() = val;},                      R"#(Sets flag for define if Plane converted to BSpline surface.)#"
         )
       .def_property("ConvertBezierSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertBezierSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertBezierSurf() = val;},                      R"#(Sets flag for define if Bezier surface converted to BSpline surface.)#"
         )
       .def_property("ConvertRevolutionSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertRevolutionSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertRevolutionSurf() = val;},                      R"#(Sets flag for define if surface of Revolution converted to BSpline surface.)#"
         )
       .def_property("ConvertExtrusionSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertExtrusionSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertExtrusionSurf() = val;},                      R"#(Sets flag for define if surface of LinearExtrusion converted to BSpline surface.)#"
         )
       .def_property("ConvertOffsetSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertOffsetSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertOffsetSurf() = val;},                      R"#(Sets flag for define if Offset surface converted to BSpline surface.)#"
         )
       .def_property("SegmentSurfaceMode",
                     [](ShapeCustom_RestrictionParameters& self){return self.SegmentSurfaceMode();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.SegmentSurfaceMode() = val;},                      R"#(Sets Segment mode for surface. If Segment is True surface is approximated in the bondaries of face lying on this surface.)#"
         )
       .def_property("ConvertCurve3d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertCurve3d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertCurve3d() = val;},                      R"#(Sets flag for define if 3d curve converted to BSpline curve.)#"
         )
       .def_property("ConvertOffsetCurv3d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertOffsetCurv3d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertOffsetCurv3d() = val;},                      R"#(Sets flag for define if Offset curve3d converted to BSpline surface.)#"
         )
       .def_property("ConvertCurve2d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertCurve2d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertCurve2d() = val;},                      R"#(Returns (modifiable) flag for define if 2d curve converted to BSpline curve.)#"
         )
       .def_property("ConvertOffsetCurv2d",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertOffsetCurv2d();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertOffsetCurv2d() = val;},                      R"#(Returns (modifiable) flag for define if Offset curve2d converted to BSpline surface.)#"
         )
       .def_property("ConvertConicalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertConicalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertConicalSurf() = val;},                      R"#(Sets flag for define if conical surface converted to BSpline surface.)#"
         )
       .def_property("ConvertSphericalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertSphericalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertSphericalSurf() = val;},                      R"#(Sets flag for define if spherical surface converted to BSpline surface.)#"
         )
       .def_property("ConvertToroidalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertToroidalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertToroidalSurf() = val;},                      R"#(Sets flag for define if toroidal surface converted to BSpline surface.)#"
         )
       .def_property("ConvertCylindricalSurf",
                     [](ShapeCustom_RestrictionParameters& self){return self.ConvertCylindricalSurf();} ,
                     [](ShapeCustom_RestrictionParameters& self, Standard_Boolean  val){self.ConvertCylindricalSurf() = val;},                      R"#(Sets flag for define if cylindrical surface converted to BSpline surface.)#"
         )
;

    // Class ShapeCustom_Surface from ./opencascade/ShapeCustom_Surface.hxx
    klass = m.attr("ShapeCustom_Surface");


    // nested enums

    static_cast<py::class_<ShapeCustom_Surface , shared_ptr<ShapeCustom_Surface>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Geom_Surface> & >()  , py::arg("S") )
    // custom constructors
    // methods
        .def("Init",
             (void (ShapeCustom_Surface::*)( const opencascade::handle<Geom_Surface> &  ) ) static_cast<void (ShapeCustom_Surface::*)( const opencascade::handle<Geom_Surface> &  ) >(&ShapeCustom_Surface::Init),
             R"#(None)#"  , py::arg("S")
          )
        .def("Gap",
             (Standard_Real (ShapeCustom_Surface::*)() const) static_cast<Standard_Real (ShapeCustom_Surface::*)() const>(&ShapeCustom_Surface::Gap),
             R"#(Returns maximal deviation of converted surface from the original one computed by last call to ConvertToAnalytical)#" 
          )
        .def("ConvertToAnalytical",
             (opencascade::handle<Geom_Surface> (ShapeCustom_Surface::*)( const Standard_Real ,  const Standard_Boolean  ) ) static_cast<opencascade::handle<Geom_Surface> (ShapeCustom_Surface::*)( const Standard_Real ,  const Standard_Boolean  ) >(&ShapeCustom_Surface::ConvertToAnalytical),
             R"#(Tries to convert the Surface to an Analytic form Returns the result Works only if the Surface is BSpline or Bezier. Else, or in case of failure, returns a Null Handle)#"  , py::arg("tol"),  py::arg("substitute")
          )
        .def("ConvertToPeriodic",
             (opencascade::handle<Geom_Surface> (ShapeCustom_Surface::*)( const Standard_Boolean ,  const Standard_Real  ) ) static_cast<opencascade::handle<Geom_Surface> (ShapeCustom_Surface::*)( const Standard_Boolean ,  const Standard_Real  ) >(&ShapeCustom_Surface::ConvertToPeriodic),
             R"#(Tries to convert the Surface to the Periodic form Returns the resulting surface Works only if the Surface is BSpline and is closed with Precision::Confusion() Else, or in case of failure, returns a Null Handle)#"  , py::arg("substitute"),  py::arg("preci")=static_cast<const Standard_Real>(- 1)
          )
        .def("Gap",
             (Standard_Real (ShapeCustom_Surface::*)() const) static_cast<Standard_Real (ShapeCustom_Surface::*)() const>(&ShapeCustom_Surface::Gap),
             R"#(Returns maximal deviation of converted surface from the original one computed by last call to ConvertToAnalytical)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class ShapeCustom_TrsfModification from ./opencascade/ShapeCustom_TrsfModification.hxx
    klass = m.attr("ShapeCustom_TrsfModification");


    // nested enums

    static_cast<py::class_<ShapeCustom_TrsfModification ,opencascade::handle<ShapeCustom_TrsfModification>  , BRepTools_TrsfModification >>(klass)
    // constructors
        .def(py::init< const gp_Trsf & >()  , py::arg("T") )
    // custom constructors
    // methods
        .def("NewSurface",
             (Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) ) static_cast<Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) >(&ShapeCustom_TrsfModification::NewSurface),
             R"#(Calls inherited method. Sets <Tol> as actual tolerance of <F> multiplied with scale factor.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("RevWires"),  py::arg("RevFace")
          )
        .def("NewCurve",
             (Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) >(&ShapeCustom_TrsfModification::NewCurve),
             R"#(Calls inherited method. Sets <Tol> as actual tolerance of <E> multiplied with scale factor.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("NewPoint",
             (Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) >(&ShapeCustom_TrsfModification::NewPoint),
             R"#(Calls inherited method. Sets <Tol> as actual tolerance of <V> multiplied with scale factor.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("NewCurve2d",
             (Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) >(&ShapeCustom_TrsfModification::NewCurve2d),
             R"#(Calls inherited method. Sets <Tol> as actual tolerance of <E> multiplied with scale factor.)#"  , py::arg("E"),  py::arg("F"),  py::arg("NewE"),  py::arg("NewF"),  py::arg("C"),  py::arg("Tol")
          )
        .def("NewParameter",
             (Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_TrsfModification::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) >(&ShapeCustom_TrsfModification::NewParameter),
             R"#(Calls inherited method. Sets <Tol> as actual tolerance of <V> multiplied with scale factor.)#"  , py::arg("V"),  py::arg("E"),  py::arg("P"),  py::arg("Tol")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_TrsfModification::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_TrsfModification::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_TrsfModification::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_TrsfModification::*)() const>(&ShapeCustom_TrsfModification::DynamicType),
             R"#(None)#"
             
         )
;

    // Class ShapeCustom_BSplineRestriction from ./opencascade/ShapeCustom_BSplineRestriction.hxx
    klass = m.attr("ShapeCustom_BSplineRestriction");


    // nested enums

    static_cast<py::class_<ShapeCustom_BSplineRestriction ,opencascade::handle<ShapeCustom_BSplineRestriction>  , ShapeCustom_Modification >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Boolean,const Standard_Boolean,const Standard_Boolean,const Standard_Real,const Standard_Real,const GeomAbs_Shape,const GeomAbs_Shape,const Standard_Integer,const Standard_Integer,const Standard_Boolean,const Standard_Boolean >()  , py::arg("anApproxSurfaceFlag"),  py::arg("anApproxCurve3dFlag"),  py::arg("anApproxCurve2dFlag"),  py::arg("aTol3d"),  py::arg("aTol2d"),  py::arg("aContinuity3d"),  py::arg("aContinuity2d"),  py::arg("aMaxDegree"),  py::arg("aNbMaxSeg"),  py::arg("Degree"),  py::arg("Rational") )
        .def(py::init< const Standard_Boolean,const Standard_Boolean,const Standard_Boolean,const Standard_Real,const Standard_Real,const GeomAbs_Shape,const GeomAbs_Shape,const Standard_Integer,const Standard_Integer,const Standard_Boolean,const Standard_Boolean,const opencascade::handle<ShapeCustom_RestrictionParameters> & >()  , py::arg("anApproxSurfaceFlag"),  py::arg("anApproxCurve3dFlag"),  py::arg("anApproxCurve2dFlag"),  py::arg("aTol3d"),  py::arg("aTol2d"),  py::arg("aContinuity3d"),  py::arg("aContinuity2d"),  py::arg("aMaxDegree"),  py::arg("aNbMaxSeg"),  py::arg("Degree"),  py::arg("Rational"),  py::arg("aModes") )
    // custom constructors
    // methods
        .def("NewSurface",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) >(&ShapeCustom_BSplineRestriction::NewSurface),
             R"#(Returns Standard_True if the face <F> has been modified. In this case, <S> is the new geometric support of the face, <L> the new location,<Tol> the new tolerance.<RevWires> has to be set to Standard_True when the modification reverses the normal of the surface.(the wires have to be reversed). <RevFace> has to be set to Standard_True if the orientation of the modified face changes in the shells which contain it.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("RevWires"),  py::arg("RevFace")
          )
        .def("NewCurve",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) >(&ShapeCustom_BSplineRestriction::NewCurve),
             R"#(Returns Standard_True if curve from the edge <E> has been modified. In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_True if Surface is modified or one of pcurves of edge is modified. In this case C is copy of geometric support of the edge. In other cases returns Standard_False, and <C>, <L>, <Tol> are not significant.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("NewCurve2d",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) >(&ShapeCustom_BSplineRestriction::NewCurve2d),
             R"#(Returns Standard_True if the edge <E> has been modified. In this case,if curve on the surface is modified, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance. If curve on the surface is not modified C is copy curve on surface from the edge <E>.)#"  , py::arg("E"),  py::arg("F"),  py::arg("NewE"),  py::arg("NewF"),  py::arg("C"),  py::arg("Tol")
          )
        .def("ConvertSurface",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<Geom_Surface> & ,  opencascade::handle<Geom_Surface> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<Geom_Surface> & ,  opencascade::handle<Geom_Surface> & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Boolean  ) >(&ShapeCustom_BSplineRestriction::ConvertSurface),
             R"#(Returns Standard_True if the surface has been modified. if flag IsOf equals Standard_True Offset surfaces are approximated to Offset if Standard_False to BSpline)#"  , py::arg("aSurface"),  py::arg("S"),  py::arg("UF"),  py::arg("UL"),  py::arg("VF"),  py::arg("VL"),  py::arg("IsOf")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("ConvertCurve",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<Geom_Curve> & ,  opencascade::handle<Geom_Curve> & ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Real ,  Standard_Real & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<Geom_Curve> & ,  opencascade::handle<Geom_Curve> & ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Real ,  Standard_Real & ,  const Standard_Boolean  ) >(&ShapeCustom_BSplineRestriction::ConvertCurve),
             R"#(Returns Standard_True if the curve has been modified. if flag IsOf equals Standard_True Offset curves are approximated to Offset if Standard_False to BSpline)#"  , py::arg("aCurve"),  py::arg("C"),  py::arg("IsConvert"),  py::arg("First"),  py::arg("Last"),  py::arg("TolCur"),  py::arg("IsOf")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("ConvertCurve2d",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<Geom2d_Curve> & ,  opencascade::handle<Geom2d_Curve> & ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Real ,  Standard_Real & ,  const Standard_Boolean  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<Geom2d_Curve> & ,  opencascade::handle<Geom2d_Curve> & ,  const Standard_Boolean ,  const Standard_Real ,  const Standard_Real ,  Standard_Real & ,  const Standard_Boolean  ) >(&ShapeCustom_BSplineRestriction::ConvertCurve2d),
             R"#(Returns Standard_True if the pcurve has been modified. if flag IsOf equals Standard_True Offset pcurves are approximated to Offset if Standard_False to BSpline)#"  , py::arg("aCurve"),  py::arg("C"),  py::arg("IsConvert"),  py::arg("First"),  py::arg("Last"),  py::arg("TolCur"),  py::arg("IsOf")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetTol3d",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) >(&ShapeCustom_BSplineRestriction::SetTol3d),
             R"#(Sets tolerance of approximation for curve3d and surface)#"  , py::arg("Tol3d")
          )
        .def("SetTol2d",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) >(&ShapeCustom_BSplineRestriction::SetTol2d),
             R"#(Sets tolerance of approximation for curve2d)#"  , py::arg("Tol2d")
          )
        .def("SetContinuity3d",
             (void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) >(&ShapeCustom_BSplineRestriction::SetContinuity3d),
             R"#(Sets continuity3d for approximation curve3d and surface.)#"  , py::arg("Continuity3d")
          )
        .def("SetContinuity2d",
             (void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) >(&ShapeCustom_BSplineRestriction::SetContinuity2d),
             R"#(Sets continuity3d for approximation curve2d.)#"  , py::arg("Continuity2d")
          )
        .def("SetMaxDegree",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) >(&ShapeCustom_BSplineRestriction::SetMaxDegree),
             R"#(Sets max degree for approximation.)#"  , py::arg("MaxDegree")
          )
        .def("SetMaxNbSegments",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) >(&ShapeCustom_BSplineRestriction::SetMaxNbSegments),
             R"#(Sets max number of segments for approximation.)#"  , py::arg("MaxNbSegments")
          )
        .def("SetPriority",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) >(&ShapeCustom_BSplineRestriction::SetPriority),
             R"#(Sets priority for approximation curves and surface. If Degree is True approximation is made with degree less then specified MaxDegree at the expense of number of spanes. If Degree is False approximation is made with number of spans less then specified MaxNbSegment at the expense of specified MaxDegree.)#"  , py::arg("Degree")
          )
        .def("SetConvRational",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) >(&ShapeCustom_BSplineRestriction::SetConvRational),
             R"#(Sets flag for define if rational BSpline or Bezier is converted to polynomial. If Rational is True approximation for rational BSpline and Bezier is made to polynomial even if degree is less then MaxDegree and number of spans is less then specified MaxNbSegment.)#"  , py::arg("Rational")
          )
        .def("GetRestrictionParameters",
             (opencascade::handle<ShapeCustom_RestrictionParameters> (ShapeCustom_BSplineRestriction::*)() const) static_cast<opencascade::handle<ShapeCustom_RestrictionParameters> (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::GetRestrictionParameters),
             R"#(Returns the container of modes which defines what geometry should be converted to BSplines.)#" 
          )
        .def("SetRestrictionParameters",
             (void (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<ShapeCustom_RestrictionParameters> &  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<ShapeCustom_RestrictionParameters> &  ) >(&ShapeCustom_BSplineRestriction::SetRestrictionParameters),
             R"#(Sets the container of modes which defines what geometry should be converted to BSplines.)#"  , py::arg("aModes")
          )
        .def("Curve3dError",
             (Standard_Real (ShapeCustom_BSplineRestriction::*)() const) static_cast<Standard_Real (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::Curve3dError),
             R"#(Returns error for approximation curve3d.)#" 
          )
        .def("Curve2dError",
             (Standard_Real (ShapeCustom_BSplineRestriction::*)() const) static_cast<Standard_Real (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::Curve2dError),
             R"#(Returns error for approximation curve2d.)#" 
          )
        .def("SurfaceError",
             (Standard_Real (ShapeCustom_BSplineRestriction::*)() const) static_cast<Standard_Real (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::SurfaceError),
             R"#(Returns error for approximation surface.)#" 
          )
        .def("NewPoint",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) >(&ShapeCustom_BSplineRestriction::NewPoint),
             R"#(None)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("NewParameter",
             (Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_BSplineRestriction::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) >(&ShapeCustom_BSplineRestriction::NewParameter),
             R"#(None)#"  , py::arg("V"),  py::arg("E"),  py::arg("P"),  py::arg("Tol")
          )
        .def("Continuity",
             (GeomAbs_Shape (ShapeCustom_BSplineRestriction::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) ) static_cast<GeomAbs_Shape (ShapeCustom_BSplineRestriction::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) >(&ShapeCustom_BSplineRestriction::Continuity),
             R"#(None)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2"),  py::arg("NewE"),  py::arg("NewF1"),  py::arg("NewF2")
          )
        .def("MaxErrors",
             (Standard_Real (ShapeCustom_BSplineRestriction::*)( Standard_Real & ,  Standard_Real &  ) const) static_cast<Standard_Real (ShapeCustom_BSplineRestriction::*)( Standard_Real & ,  Standard_Real &  ) const>(&ShapeCustom_BSplineRestriction::MaxErrors),
             R"#(Returns error for approximation surface, curve3d and curve2d.)#"  , py::arg("aCurve3dErr"),  py::arg("aCurve2dErr")
          )
        .def("NbOfSpan",
             (Standard_Integer (ShapeCustom_BSplineRestriction::*)() const) static_cast<Standard_Integer (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::NbOfSpan),
             R"#(Returns number for approximation surface, curve3d and curve2d.)#" 
          )
        .def("SetTol3d",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) >(&ShapeCustom_BSplineRestriction::SetTol3d),
             R"#(Sets tolerance of approximation for curve3d and surface)#"  , py::arg("Tol3d")
          )
        .def("SetTol2d",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Real  ) >(&ShapeCustom_BSplineRestriction::SetTol2d),
             R"#(Sets tolerance of approximation for curve2d)#"  , py::arg("Tol2d")
          )
        .def("SetContinuity3d",
             (void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) >(&ShapeCustom_BSplineRestriction::SetContinuity3d),
             R"#(Sets continuity3d for approximation curve3d and surface.)#"  , py::arg("Continuity3d")
          )
        .def("SetContinuity2d",
             (void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const GeomAbs_Shape  ) >(&ShapeCustom_BSplineRestriction::SetContinuity2d),
             R"#(Sets continuity3d for approximation curve2d.)#"  , py::arg("Continuity2d")
          )
        .def("SetMaxDegree",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) >(&ShapeCustom_BSplineRestriction::SetMaxDegree),
             R"#(Sets max degree for approximation.)#"  , py::arg("MaxDegree")
          )
        .def("SetMaxNbSegments",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Integer  ) >(&ShapeCustom_BSplineRestriction::SetMaxNbSegments),
             R"#(Sets max number of segments for approximation.)#"  , py::arg("MaxNbSegments")
          )
        .def("Curve3dError",
             (Standard_Real (ShapeCustom_BSplineRestriction::*)() const) static_cast<Standard_Real (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::Curve3dError),
             R"#(Returns error for approximation curve3d.)#" 
          )
        .def("Curve2dError",
             (Standard_Real (ShapeCustom_BSplineRestriction::*)() const) static_cast<Standard_Real (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::Curve2dError),
             R"#(Returns error for approximation curve2d.)#" 
          )
        .def("SurfaceError",
             (Standard_Real (ShapeCustom_BSplineRestriction::*)() const) static_cast<Standard_Real (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::SurfaceError),
             R"#(Returns error for approximation surface.)#" 
          )
        .def("SetPriority",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) >(&ShapeCustom_BSplineRestriction::SetPriority),
             R"#(Sets priority for approximation curves and surface. If Degree is True approximation is made with degree less then specified MaxDegree at the expense of number of spanes. If Degree is False approximation is made with number of spans less then specified MaxNbSegment at the expense of specified MaxDegree.)#"  , py::arg("Degree")
          )
        .def("SetConvRational",
             (void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const Standard_Boolean  ) >(&ShapeCustom_BSplineRestriction::SetConvRational),
             R"#(Sets flag for define if rational BSpline or Bezier is converted to polynomial. If Rational is True approximation for rational BSpline and Bezier is made to polynomial even if degree is less then MaxDegree and number of spans is less then specified MaxNbSegment.)#"  , py::arg("Rational")
          )
        .def("GetRestrictionParameters",
             (opencascade::handle<ShapeCustom_RestrictionParameters> (ShapeCustom_BSplineRestriction::*)() const) static_cast<opencascade::handle<ShapeCustom_RestrictionParameters> (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::GetRestrictionParameters),
             R"#(Returns the container of modes which defines what geometry should be converted to BSplines.)#" 
          )
        .def("SetRestrictionParameters",
             (void (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<ShapeCustom_RestrictionParameters> &  ) ) static_cast<void (ShapeCustom_BSplineRestriction::*)( const opencascade::handle<ShapeCustom_RestrictionParameters> &  ) >(&ShapeCustom_BSplineRestriction::SetRestrictionParameters),
             R"#(Sets the container of modes which defines what geometry should be converted to BSplines.)#"  , py::arg("aModes")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_BSplineRestriction::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_BSplineRestriction::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def_property("ModifyApproxSurfaceFlag",
                     [](ShapeCustom_BSplineRestriction& self){return self.ModifyApproxSurfaceFlag();} ,
                     [](ShapeCustom_BSplineRestriction& self, Standard_Boolean  val){self.ModifyApproxSurfaceFlag() = val;},                      R"#(Returns (modifiable) the flag which defines whether the surface is approximated.)#"
         )
       .def_property("ModifyApproxCurve3dFlag",
                     [](ShapeCustom_BSplineRestriction& self){return self.ModifyApproxCurve3dFlag();} ,
                     [](ShapeCustom_BSplineRestriction& self, Standard_Boolean  val){self.ModifyApproxCurve3dFlag() = val;},                      R"#(Returns (modifiable) the flag which defines whether the curve3d is approximated.)#"
         )
       .def_property("ModifyApproxCurve2dFlag",
                     [](ShapeCustom_BSplineRestriction& self){return self.ModifyApproxCurve2dFlag();} ,
                     [](ShapeCustom_BSplineRestriction& self, Standard_Boolean  val){self.ModifyApproxCurve2dFlag() = val;},                      R"#(Returns (modifiable) the flag which defines whether the curve2d is approximated.)#"
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_BSplineRestriction::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_BSplineRestriction::*)() const>(&ShapeCustom_BSplineRestriction::DynamicType),
             R"#(None)#"
             
         )
       .def_property("ModifyApproxSurfaceFlag",
                     [](ShapeCustom_BSplineRestriction& self){return self.ModifyApproxSurfaceFlag();} ,
                     [](ShapeCustom_BSplineRestriction& self, Standard_Boolean  val){self.ModifyApproxSurfaceFlag() = val;},                      R"#(Returns (modifiable) the flag which defines whether the surface is approximated.)#"
         )
       .def_property("ModifyApproxCurve3dFlag",
                     [](ShapeCustom_BSplineRestriction& self){return self.ModifyApproxCurve3dFlag();} ,
                     [](ShapeCustom_BSplineRestriction& self, Standard_Boolean  val){self.ModifyApproxCurve3dFlag() = val;},                      R"#(Returns (modifiable) the flag which defines whether the curve3d is approximated.)#"
         )
       .def_property("ModifyApproxCurve2dFlag",
                     [](ShapeCustom_BSplineRestriction& self){return self.ModifyApproxCurve2dFlag();} ,
                     [](ShapeCustom_BSplineRestriction& self, Standard_Boolean  val){self.ModifyApproxCurve2dFlag() = val;},                      R"#(Returns (modifiable) the flag which defines whether the curve2d is approximated.)#"
         )
;

    // Class ShapeCustom_ConvertToBSpline from ./opencascade/ShapeCustom_ConvertToBSpline.hxx
    klass = m.attr("ShapeCustom_ConvertToBSpline");


    // nested enums

    static_cast<py::class_<ShapeCustom_ConvertToBSpline ,opencascade::handle<ShapeCustom_ConvertToBSpline>  , ShapeCustom_Modification >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetExtrusionMode",
             (void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) >(&ShapeCustom_ConvertToBSpline::SetExtrusionMode),
             R"#(Sets mode for conversion of Surfaces of Linear extrusion.)#"  , py::arg("extrMode")
          )
        .def("SetRevolutionMode",
             (void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) >(&ShapeCustom_ConvertToBSpline::SetRevolutionMode),
             R"#(Sets mode for conversion of Surfaces of Revolution.)#"  , py::arg("revolMode")
          )
        .def("SetOffsetMode",
             (void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) >(&ShapeCustom_ConvertToBSpline::SetOffsetMode),
             R"#(Sets mode for conversion of Offset surfaces.)#"  , py::arg("offsetMode")
          )
        .def("SetPlaneMode",
             (void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) ) static_cast<void (ShapeCustom_ConvertToBSpline::*)( const Standard_Boolean  ) >(&ShapeCustom_ConvertToBSpline::SetPlaneMode),
             R"#(Sets mode for conversion of Plane surfaces.)#"  , py::arg("planeMode")
          )
        .def("NewSurface",
             (Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) >(&ShapeCustom_ConvertToBSpline::NewSurface),
             R"#(Returns Standard_True if the face <F> has been modified. In this case, <S> is the new geometric support of the face, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <S>, <L>, <Tol> are not significant.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("RevWires"),  py::arg("RevFace")
          )
        .def("NewCurve",
             (Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToBSpline::NewCurve),
             R"#(Returns Standard_True if the edge <E> has been modified. In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <C>, <L>, <Tol> are not significant.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("NewPoint",
             (Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToBSpline::NewPoint),
             R"#(Returns Standard_True if the vertex <V> has been modified. In this case, <P> is the new geometric support of the vertex, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("NewCurve2d",
             (Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToBSpline::NewCurve2d),
             R"#(Returns Standard_True if the edge <E> has a new curve on surface on the face <F>.In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance.)#"  , py::arg("E"),  py::arg("F"),  py::arg("NewE"),  py::arg("NewF"),  py::arg("C"),  py::arg("Tol")
          )
        .def("NewParameter",
             (Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToBSpline::NewParameter),
             R"#(Returns Standard_True if the Vertex <V> has a new parameter on the edge <E>. In this case, <P> is the parameter, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("E"),  py::arg("P"),  py::arg("Tol")
          )
        .def("Continuity",
             (GeomAbs_Shape (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) ) static_cast<GeomAbs_Shape (ShapeCustom_ConvertToBSpline::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) >(&ShapeCustom_ConvertToBSpline::Continuity),
             R"#(Returns the continuity of <NewE> between <NewF1> and <NewF2>.)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2"),  py::arg("NewE"),  py::arg("NewF1"),  py::arg("NewF2")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_ConvertToBSpline::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_ConvertToBSpline::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_ConvertToBSpline::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_ConvertToBSpline::*)() const>(&ShapeCustom_ConvertToBSpline::DynamicType),
             R"#(None)#"
             
         )
;

    // Class ShapeCustom_ConvertToRevolution from ./opencascade/ShapeCustom_ConvertToRevolution.hxx
    klass = m.attr("ShapeCustom_ConvertToRevolution");


    // nested enums

    static_cast<py::class_<ShapeCustom_ConvertToRevolution ,opencascade::handle<ShapeCustom_ConvertToRevolution>  , ShapeCustom_Modification >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("NewSurface",
             (Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) >(&ShapeCustom_ConvertToRevolution::NewSurface),
             R"#(Returns Standard_True if the face <F> has been modified. In this case, <S> is the new geometric support of the face, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <S>, <L>, <Tol> are not significant.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("RevWires"),  py::arg("RevFace")
          )
        .def("NewCurve",
             (Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToRevolution::NewCurve),
             R"#(Returns Standard_True if the edge <E> has been modified. In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <C>, <L>, <Tol> are not significant.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("NewPoint",
             (Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToRevolution::NewPoint),
             R"#(Returns Standard_True if the vertex <V> has been modified. In this case, <P> is the new geometric support of the vertex, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("NewCurve2d",
             (Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToRevolution::NewCurve2d),
             R"#(Returns Standard_True if the edge <E> has a new curve on surface on the face <F>.In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance.)#"  , py::arg("E"),  py::arg("F"),  py::arg("NewE"),  py::arg("NewF"),  py::arg("C"),  py::arg("Tol")
          )
        .def("NewParameter",
             (Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) >(&ShapeCustom_ConvertToRevolution::NewParameter),
             R"#(Returns Standard_True if the Vertex <V> has a new parameter on the edge <E>. In this case, <P> is the parameter, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("E"),  py::arg("P"),  py::arg("Tol")
          )
        .def("Continuity",
             (GeomAbs_Shape (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) ) static_cast<GeomAbs_Shape (ShapeCustom_ConvertToRevolution::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) >(&ShapeCustom_ConvertToRevolution::Continuity),
             R"#(Returns the continuity of <NewE> between <NewF1> and <NewF2>.)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2"),  py::arg("NewE"),  py::arg("NewF1"),  py::arg("NewF2")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_ConvertToRevolution::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_ConvertToRevolution::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_ConvertToRevolution::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_ConvertToRevolution::*)() const>(&ShapeCustom_ConvertToRevolution::DynamicType),
             R"#(None)#"
             
         )
;

    // Class ShapeCustom_DirectModification from ./opencascade/ShapeCustom_DirectModification.hxx
    klass = m.attr("ShapeCustom_DirectModification");


    // nested enums

    static_cast<py::class_<ShapeCustom_DirectModification ,opencascade::handle<ShapeCustom_DirectModification>  , ShapeCustom_Modification >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("NewSurface",
             (Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) ) static_cast<Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) >(&ShapeCustom_DirectModification::NewSurface),
             R"#(Returns Standard_True if the face <F> has been modified. In this case, <S> is the new geometric support of the face, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <S>, <L>, <Tol> are not significant.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("RevWires"),  py::arg("RevFace")
          )
        .def("NewCurve",
             (Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) >(&ShapeCustom_DirectModification::NewCurve),
             R"#(Returns Standard_True if the edge <E> has been modified. In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <C>, <L>, <Tol> are not significant.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("NewPoint",
             (Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) >(&ShapeCustom_DirectModification::NewPoint),
             R"#(Returns Standard_True if the vertex <V> has been modified. In this case, <P> is the new geometric support of the vertex, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("NewCurve2d",
             (Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) >(&ShapeCustom_DirectModification::NewCurve2d),
             R"#(Returns Standard_True if the edge <E> has a new curve on surface on the face <F>.In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance.)#"  , py::arg("E"),  py::arg("F"),  py::arg("NewE"),  py::arg("NewF"),  py::arg("C"),  py::arg("Tol")
          )
        .def("NewParameter",
             (Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_DirectModification::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) >(&ShapeCustom_DirectModification::NewParameter),
             R"#(Returns Standard_True if the Vertex <V> has a new parameter on the edge <E>. In this case, <P> is the parameter, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("E"),  py::arg("P"),  py::arg("Tol")
          )
        .def("Continuity",
             (GeomAbs_Shape (ShapeCustom_DirectModification::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) ) static_cast<GeomAbs_Shape (ShapeCustom_DirectModification::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) >(&ShapeCustom_DirectModification::Continuity),
             R"#(Returns the continuity of <NewE> between <NewF1> and <NewF2>.)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2"),  py::arg("NewE"),  py::arg("NewF1"),  py::arg("NewF2")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_DirectModification::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_DirectModification::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_DirectModification::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_DirectModification::*)() const>(&ShapeCustom_DirectModification::DynamicType),
             R"#(None)#"
             
         )
;

    // Class ShapeCustom_SweptToElementary from ./opencascade/ShapeCustom_SweptToElementary.hxx
    klass = m.attr("ShapeCustom_SweptToElementary");


    // nested enums

    static_cast<py::class_<ShapeCustom_SweptToElementary ,opencascade::handle<ShapeCustom_SweptToElementary>  , ShapeCustom_Modification >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("NewSurface",
             (Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) ) static_cast<Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Face & ,  opencascade::handle<Geom_Surface> & ,  TopLoc_Location & ,  Standard_Real & ,  Standard_Boolean & ,  Standard_Boolean &  ) >(&ShapeCustom_SweptToElementary::NewSurface),
             R"#(Returns Standard_True if the face <F> has been modified. In this case, <S> is the new geometric support of the face, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <S>, <L>, <Tol> are not significant.)#"  , py::arg("F"),  py::arg("S"),  py::arg("L"),  py::arg("Tol"),  py::arg("RevWires"),  py::arg("RevFace")
          )
        .def("NewCurve",
             (Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Edge & ,  opencascade::handle<Geom_Curve> & ,  TopLoc_Location & ,  Standard_Real &  ) >(&ShapeCustom_SweptToElementary::NewCurve),
             R"#(Returns Standard_True if the edge <E> has been modified. In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance. Otherwise, returns Standard_False, and <C>, <L>, <Tol> are not significant.)#"  , py::arg("E"),  py::arg("C"),  py::arg("L"),  py::arg("Tol")
          )
        .def("NewPoint",
             (Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Vertex & ,  gp_Pnt & ,  Standard_Real &  ) >(&ShapeCustom_SweptToElementary::NewPoint),
             R"#(Returns Standard_True if the vertex <V> has been modified. In this case, <P> is the new geometric support of the vertex, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("P"),  py::arg("Tol")
          )
        .def("NewCurve2d",
             (Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  opencascade::handle<Geom2d_Curve> & ,  Standard_Real &  ) >(&ShapeCustom_SweptToElementary::NewCurve2d),
             R"#(Returns Standard_True if the edge <E> has a new curve on surface on the face <F>.In this case, <C> is the new geometric support of the edge, <L> the new location, <Tol> the new tolerance.)#"  , py::arg("E"),  py::arg("F"),  py::arg("NewE"),  py::arg("NewF"),  py::arg("C"),  py::arg("Tol")
          )
        .def("NewParameter",
             (Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (ShapeCustom_SweptToElementary::*)( const TopoDS_Vertex & ,  const TopoDS_Edge & ,  Standard_Real & ,  Standard_Real &  ) >(&ShapeCustom_SweptToElementary::NewParameter),
             R"#(Returns Standard_True if the Vertex <V> has a new parameter on the edge <E>. In this case, <P> is the parameter, <Tol> the new tolerance. Otherwise, returns Standard_False, and <P>, <Tol> are not significant.)#"  , py::arg("V"),  py::arg("E"),  py::arg("P"),  py::arg("Tol")
          )
        .def("Continuity",
             (GeomAbs_Shape (ShapeCustom_SweptToElementary::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) ) static_cast<GeomAbs_Shape (ShapeCustom_SweptToElementary::*)( const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face & ,  const TopoDS_Edge & ,  const TopoDS_Face & ,  const TopoDS_Face &  ) >(&ShapeCustom_SweptToElementary::Continuity),
             R"#(Returns the continuity of <NewE> between <NewF1> and <NewF2>.)#"  , py::arg("E"),  py::arg("F1"),  py::arg("F2"),  py::arg("NewE"),  py::arg("NewF1"),  py::arg("NewF2")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&ShapeCustom_SweptToElementary::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&ShapeCustom_SweptToElementary::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (ShapeCustom_SweptToElementary::*)() const) static_cast<const opencascade::handle<Standard_Type> & (ShapeCustom_SweptToElementary::*)() const>(&ShapeCustom_SweptToElementary::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/ShapeCustom.hxx
// ./opencascade/ShapeCustom_BSplineRestriction.hxx
// ./opencascade/ShapeCustom_ConvertToBSpline.hxx
// ./opencascade/ShapeCustom_ConvertToRevolution.hxx
// ./opencascade/ShapeCustom_Curve.hxx
// ./opencascade/ShapeCustom_Curve2d.hxx
// ./opencascade/ShapeCustom_DirectModification.hxx
// ./opencascade/ShapeCustom_Modification.hxx
// ./opencascade/ShapeCustom_RestrictionParameters.hxx
// ./opencascade/ShapeCustom_Surface.hxx
// ./opencascade/ShapeCustom_SweptToElementary.hxx
// ./opencascade/ShapeCustom_TrsfModification.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
