% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial.cor.R
\name{partial.cor}
\alias{partial.cor}
\alias{print.partial.cor}
\title{Partial Correlations}
\usage{
partial.cor(X, tests = FALSE, use = c("complete.obs", "pairwise.complete.obs"))

\method{print}{partial.cor}(x, digits = max(3, getOption("digits") - 2), ...)
}
\arguments{
\item{X}{data matrix.}

\item{tests}{show two-sided p-value and p-value adjusted for multiple testing by Holm's method for each partial correlation.}

\item{use}{observations to use to compute partial correlations, default is \code{"complete.obs"}.}

\item{x}{data matrix.}

\item{digits}{minimal number of _significant_ digits, see \code{\link[base]{print.default}}.}

\item{\dots}{arguments to pass down from the print method.}
}
\value{
Returns the matrix of partial correlations, optionally with adjusted and unadjusted p-values.
}
\description{
Partial Correlations
}
\details{
Computes a matrix of partial correlations between each pair of variables controlling for the others.
}
\examples{
data(DavisThin, package="car")
partial.cor(DavisThin)
partial.cor(DavisThin, tests=TRUE)

}
\seealso{
\code{\link[stats]{cor}}
}
\author{
John Fox
}
\keyword{misc}
