% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/tol.R
\name{tol_lineage}
\alias{tol_lineage}
\alias{tol_node_info}
\alias{tax_rank.tol_node}
\alias{tax_sources.tol_node}
\alias{unique_name.tol_node}
\alias{tax_name.tol_node}
\alias{ott_id.tol_node}
\alias{source_list.tol_node}
\alias{tax_lineage.tol_node}
\alias{tol_lineage.tol_node}
\title{Node info}
\usage{
tol_lineage(tax, ...)

tol_node_info(ott_id = NULL, node_id = NULL, include_lineage = FALSE, ...)

\method{tax_rank}{tol_node}(tax, ...)

\method{tax_sources}{tol_node}(tax, ...)

\method{unique_name}{tol_node}(tax, ...)

\method{tax_name}{tol_node}(tax, ...)

\method{ott_id}{tol_node}(tax, ...)

\method{source_list}{tol_node}(tax, ...)

\method{tax_lineage}{tol_node}(tax, ...)

\method{tol_lineage}{tol_node}(tax, ...)
}
\arguments{
\item{tax}{an object returned by \code{tol_node_info}.}

\item{...}{additional arguments to customize the API call (see
?rotl for more information)}

\item{ott_id}{Numeric. The OpenTree taxonomic identifier.}

\item{node_id}{Character. The OpenTree node identifier.}

\item{include_lineage}{Logical (default = FALSE). Whether to return the
lineage of the node from the synthetic tree.}
}
\value{
\code{tol_node_info} returns an invisible list of summary
    information about the queried node:

\describe{

    \item{node_id}{String. The canonical identifier of the node.}

    \item{num_tips}{Numeric. The number of descendant tips.}

    \item{partial_path_of}{List. The edge below this synthetic tree node
    is compatible with the edge below each of these input tree nodes (one
    per tree). Each returned element is reported as sourceid:nodeid.}

   \item{query}{ The node id that resolved to this node. This can differ
   from the node_id field if the query id is not canonical. }

    \item{taxon}{A list of taxonomic properties. Only returned if
    the queried node is a taxon. Each source has:}

        \describe{
            \item{ott_id}{Numeric. The OpenTree Taxonomy ID (ottID).}

            \item{name}{String. The taxonomic name of the queried node.}

            \item{unique_name}{String. The string that uniquely
            identifies the taxon in OTT.}

            \item{rank}{String. The taxonomic rank of the taxon in OTT.}

            \item{tax_sources}{List. A list of identifiers for taxonomic
            sources, such as other taxonomies, that define taxa judged
            equivalent to this taxon.}
        }

    The following properties list support/conflict for the node across
    synthesis source trees. All properties involve sourceid keys and
    nodeid values (see \code{source_id_map} below).

    \item{supported_by}{List. Input tree nodes (one per tree) that support
    this synthetic tree node. Each returned element is reported as
    sourceid:nodeid.}

    \item{terminal}{List. Input tree nodes (one per tree) that are
    equivalent to this synthetic tree node (via an exact mapping, or the
    input tree terminal may be the only terminal descended from this
    synthetic tree node. Each returned element is reported as
    sourceid:nodeid.}

    \item{conflicts_with}{Named list of lists. Names correspond to
    sourceid keys. Each list contains input tree node ids (one or more per
    tree) that conflict with this synthetic node.}
  }

    \code{tol_lineage} and \code{tax_lineage} return data
        frames. \code{tol_lineage} indicate for each ancestor its
        node identifier, the number of tips descending from that
        node, and whether it corresponds to a taxonomic level.
}
\description{
Get summary information about a node in the synthetic tree
}
\details{
Returns summary information about a node in the graph. The
    node of interest may be specified using either a node id or an
    taxon id, but not both. If the specified node or OTT id is not
    in the graph, an error will be returned.

    If the argument \code{include_lineage=TRUE} is used, you can
    use \code{tax_lineage()} or \code{tol_lineage} to return the
    taxonomic information or the node information for all the
    ancestors to this node, down to the root of the tree.
}
\examples{
\dontrun{
birds <- tol_node_info(ott_id=81461, include_lineage=TRUE)
source_list(birds)
tax_rank(birds)
ott_id(birds)
tax_lineage(birds)
tol_lineage(birds)}
}
